/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.refactoring.MavenRefactoringElementImplementation;
import org.netbeans.modules.maven.refactoring.ReferringClass;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;

class MavenRefactoringPlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(MavenRefactoringPlugin.class.getName());
    private final WhereUsedQuery query;
    private final TreePathHandle handle;

    MavenRefactoringPlugin(WhereUsedQuery query, TreePathHandle handle) {
        this.query = query;
        this.handle = handle;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (!this.query.getBooleanValue((Object)"FIND_REFERENCES")) {
            return null;
        }
        final AtomicReference fqn = new AtomicReference();
        CancellableTask<CompilationController> info = new CancellableTask<CompilationController>(){

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element e = MavenRefactoringPlugin.this.handle.resolveElement((CompilationInfo)info);
                if (e == null) {
                    LOG.log(Level.WARNING, "no element for {0}", MavenRefactoringPlugin.this.handle);
                    return;
                }
                switch (e.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ANNOTATION_TYPE: 
                    case ENUM: {
                        fqn.set(info.getElements().getBinaryName((TypeElement)e).toString());
                        break;
                    }
                    default: {
                        LOG.log(Level.FINE, "unexpected element {0}", e);
                    }
                }
            }

            public void cancel() {
            }
        };
        JavaSource source = JavaSource.forFileObject((FileObject)this.handle.getFileObject());
        if (source != null) {
            try {
                source.runUserActionTask((Task)info, true);
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, null, x);
            }
        } else {
            LOG.log(Level.WARNING, "no source for {0}", this.handle.getFileObject());
        }
        LOG.log(Level.FINE, "for {0} found FQN: {1}", new Object[]{this.handle, fqn});
        if (fqn.get() != null) {
            long start = System.currentTimeMillis();
            List results = RepositoryQueries.findClassUsagesResult((String)((String)fqn.get()), (List)RepositoryQueries.getLoadedContexts()).getResults();
            long end = System.currentTimeMillis();
            LOG.log(Level.FINE, "took {0}msec to find {1}", new Object[]{end - start, fqn});
            for (RepositoryQueries.ClassUsage result : results) {
                for (String clazz : result.getClasses()) {
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)new MavenRefactoringElementImplementation(new ReferringClass(result.getArtifact(), clazz)));
                }
            }
        }
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }
}

