/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;

class LazyArrayList<T>
extends ArrayList<T> {
    private final Map<Integer, LazyEntry<T>> lazyEntries = new HashMap<Integer, LazyEntry<T>>();

    LazyArrayList() {
    }

    @Override
    public Object[] toArray() {
        Object[] arr = super.toArray();
        for (int i = 0; i < arr.length; ++i) {
            LazyEntry<T> le = this.lazyEntries.remove(i);
            if (le == null) continue;
            arr[i] = le.get();
            this.set(i, arr[i]);
        }
        return arr;
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        TT[] arr = super.toArray(a);
        for (int i = 0; i < arr.length; ++i) {
            LazyEntry<T> le = this.lazyEntries.remove(i);
            if (le == null) continue;
            T e = le.get();
            arr[i] = e;
            this.set(i, e);
        }
        return arr;
    }

    private Object[] toOriginalArray() {
        return super.toArray();
    }

    @Override
    public boolean add(LazyEntry<T> e) {
        this.lazyEntries.put(this.size(), e);
        return this.add(null);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof LazyEntry) {
            for (Integer i : this.lazyEntries.keySet()) {
                if (!o.equals(this.lazyEntries.get(i))) continue;
                super.remove(i);
                this.lazyEntries.remove(i);
                this.shiftLazyEntries(i, -1);
                return true;
            }
            return false;
        }
        return super.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c instanceof LazyArrayList) {
            LazyArrayList lazyArrayList = (LazyArrayList)c;
            int s = this.size();
            Map<Integer, LazyEntry<T>> newLazyEntries = lazyArrayList.lazyEntries;
            for (Map.Entry<Integer, LazyEntry<T>> e : newLazyEntries.entrySet()) {
                this.lazyEntries.put(e.getKey() + s, e.getValue());
            }
            return super.addAll(Arrays.asList(lazyArrayList.toOriginalArray()));
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        this.lazyEntries.clear();
        super.clear();
    }

    @Override
    public T get(int index) {
        LazyEntry<T> le = this.lazyEntries.remove(index);
        if (le != null) {
            T e = le.get();
            this.set(index, e);
            return e;
        }
        return (T)super.get(index);
    }

    protected T getRaw(int index) {
        return (T)super.get(index);
    }

    public Object getEntry(int index) {
        LazyEntry<T> le = this.lazyEntries.get(index);
        if (le != null) {
            return le;
        }
        return super.get(index);
    }

    @Override
    public void add(int index, T element) {
        this.shiftLazyEntries(index, 1);
        super.add(index, element);
    }

    @Override
    public T remove(int index) {
        LazyEntry<T> le = this.lazyEntries.remove(index);
        if (le != null) {
            T e = le.get();
            super.remove(index);
            this.shiftLazyEntries(index, -1);
            return e;
        }
        return (T)super.remove(index);
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    private void shiftLazyEntries(int from, final int by) {
        TreeSet<Integer> indexes = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int i1 = o1;
                int i2 = o2;
                return (int)(Math.signum(i2 - i1) * Math.signum(by));
            }
        });
        indexes.addAll(this.lazyEntries.keySet());
        for (Integer i : indexes) {
            if (i < from) continue;
            this.lazyEntries.put(i + by, this.lazyEntries.remove(i));
        }
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyArrayList)) {
            return false;
        }
        LazyArrayList l = (LazyArrayList)o;
        if (this.size() != l.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object o1 = this.getEntry(i);
            Object o2 = l.getEntry(i);
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size(); ++i) {
            Object obj = this.getEntry(i);
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    static /* synthetic */ int access$100(LazyArrayList x0) {
        return x0.modCount;
    }

    protected static abstract class LazyEntry<T> {
        protected LazyEntry() {
        }

        protected abstract T get();
    }

    private class Itr
    implements Iterator {
        private int cursor = 0;
        private int expectedModCount = LazyArrayList.access$100(LazyArrayList.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < LazyArrayList.this.size();
        }

        public Object next() {
            if (this.cursor >= LazyArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            if (LazyArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return LazyArrayList.this.get(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

