/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.options;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.snaptracer.impl.options.TracerOptionsPanelController;
import org.netbeans.modules.profiler.snaptracer.impl.swing.CustomComboRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.SectionSeparator;
import org.netbeans.modules.profiler.snaptracer.impl.swing.Spacer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.VerticalLayout;

final class TracerOptionsPanel
extends JPanel {
    private final TracerOptionsPanelController controller;
    private boolean internalChange;
    private JComboBox probesDefaultsCombo;
    private JComboBox refreshCombo;
    private JCheckBox refreshCheckBox;
    private JComboBox minMaxValsCombo;
    private JComboBox rowLegendCombo;
    private JComboBox rowsDecorationCombo;
    private JComboBox rowsSelectionCombo;
    private JComboBox timelineToolbarCombo;
    private JComboBox selectionToolbarCombo;
    private JComboBox extraToolbarCombo;
    private JPanel initiallyOpenedPanel;
    private JCheckBox initialProbesCheckBox;
    private JCheckBox initialTimelineCheckBox;
    private JCheckBox initialDetailsCheckBox;
    private JPanel onProbeAddedPanel;
    private JCheckBox onProbeAddedProbesCheckBox;
    private JCheckBox onProbeAddedTimelineCheckBox;
    private JCheckBox onProbeAddedDetailsCheckBox;
    private JCheckBox onProbeAddedNothingCheckBox;
    private JPanel onProbeAddedPanel2;
    private JCheckBox onProbeAddedProbesCheckBox2;
    private JCheckBox onProbeAddedTimelineCheckBox2;
    private JCheckBox onProbeAddedDetailsCheckBox2;
    private JCheckBox onProbeAddedNothingCheckBox2;
    private JPanel onStartOpenedPanel;
    private JCheckBox onStartProbesCheckBox;
    private JCheckBox onStartTimelineCheckBox;
    private JCheckBox onStartDetailsCheckBox;
    private JCheckBox onStartNothingCheckBox;
    private JPanel onRowSelectedPanel;
    private JCheckBox onRowSelectedProbesCheckBox;
    private JCheckBox onRowSelectedTimelineCheckBox;
    private JCheckBox onRowSelectedDetailsCheckBox;
    private JCheckBox onRowSelectedNothingCheckBox;
    private JPanel onRowSelectedPanel2;
    private JCheckBox onRowSelectedProbesCheckBox2;
    private JCheckBox onRowSelectedTimelineCheckBox2;
    private JCheckBox onRowSelectedDetailsCheckBox2;
    private JCheckBox onRowSelectedNothingCheckBox2;
    private JCheckBox clearSelectionsCheckBox;
    private JComboBox zoomModeCombo;
    private JComboBox mouseWheelCombo;

    TracerOptionsPanel(TracerOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    boolean dataValid() {
        return true;
    }

    void setProbesApp(int probesApp) {
        this.internalChange = true;
        this.probesDefaultsCombo.setSelectedIndex(probesApp);
        this.internalChange = false;
    }

    int getProbesApp() {
        return this.probesDefaultsCombo.getSelectedIndex();
    }

    void setRefresh(int refresh) {
        this.internalChange = true;
        this.refreshCombo.setSelectedItem(refresh);
        this.internalChange = false;
    }

    int getRefresh() {
        return (Integer)this.refreshCombo.getSelectedItem();
    }

    void setRefreshCustomizable(boolean customizable) {
        this.refreshCheckBox.setSelected(customizable);
    }

    boolean isRefreshCustomizable() {
        return this.refreshCheckBox.isSelected();
    }

    void setShowValuesEnabled(boolean showValuesEnabled) {
        this.internalChange = true;
        this.minMaxValsCombo.setSelectedItem(showValuesEnabled);
        this.internalChange = false;
    }

    boolean isShowValuesEnabled() {
        return (Boolean)this.minMaxValsCombo.getSelectedItem();
    }

    void setShowLegendEnabled(boolean showLegendEnabled) {
        this.internalChange = true;
        this.rowLegendCombo.setSelectedItem(showLegendEnabled);
        this.internalChange = false;
    }

    boolean isShowLegendEnabled() {
        return (Boolean)this.rowLegendCombo.getSelectedItem();
    }

    void setRowsDecorationEnabled(boolean rowsDecorationEnabled) {
        this.internalChange = true;
        this.rowsDecorationCombo.setSelectedItem(rowsDecorationEnabled);
        this.internalChange = false;
    }

    boolean isRowsDecorationEnabled() {
        return (Boolean)this.rowsDecorationCombo.getSelectedItem();
    }

    void setRowsSelectionEnabled(boolean rowsSelectionEnabled) {
        this.internalChange = true;
        this.rowsSelectionCombo.setSelectedIndex(rowsSelectionEnabled ? 0 : 1);
        this.internalChange = false;
    }

    boolean isRowsSelectionEnabled() {
        return this.rowsSelectionCombo.getSelectedIndex() == 0;
    }

    void setTimelineToolbar(int visible) {
        this.internalChange = true;
        this.timelineToolbarCombo.setSelectedIndex(visible);
        this.internalChange = false;
    }

    int getTimelineToolbar() {
        return this.timelineToolbarCombo.getSelectedIndex();
    }

    void setSelectionToolbar(int visible) {
        this.internalChange = true;
        this.selectionToolbarCombo.setSelectedIndex(visible);
        this.internalChange = false;
    }

    int getSelectionToolbar() {
        return this.selectionToolbarCombo.getSelectedIndex();
    }

    void setExtraToolbar(int visible) {
        this.internalChange = true;
        this.extraToolbarCombo.setSelectedIndex(visible);
        this.internalChange = false;
    }

    int getExtraToolbar() {
        return this.extraToolbarCombo.getSelectedIndex();
    }

    void setInitiallyOpened(String opened) {
        this.internalChange = true;
        this.initialProbesCheckBox.setSelected(opened.contains("KEY_probes"));
        this.initialTimelineCheckBox.setSelected(opened.contains("KEY_timeline"));
        this.initialDetailsCheckBox.setSelected(opened.contains("KEY_details"));
        this.internalChange = false;
    }

    String getInitiallyOpened() {
        String result = "";
        result = this.append(result, "KEY_probes", this.initialProbesCheckBox.isSelected());
        result = this.append(result, "KEY_timeline", this.initialTimelineCheckBox.isSelected());
        result = this.append(result, "KEY_details", this.initialDetailsCheckBox.isSelected());
        return result;
    }

    void setOnProbeAdded(String opened) {
        this.internalChange = true;
        if ("".equals(opened)) {
            this.onProbeAddedProbesCheckBox.setSelected(false);
            this.onProbeAddedTimelineCheckBox.setSelected(false);
            this.onProbeAddedDetailsCheckBox.setSelected(false);
            this.onProbeAddedNothingCheckBox.setSelected(true);
        } else {
            this.onProbeAddedProbesCheckBox.setSelected(opened.contains("KEY_probes"));
            this.onProbeAddedTimelineCheckBox.setSelected(opened.contains("KEY_timeline"));
            this.onProbeAddedDetailsCheckBox.setSelected(opened.contains("KEY_details"));
            this.onProbeAddedNothingCheckBox.setSelected(false);
        }
        this.internalChange = false;
    }

    String getOnProbeAdded() {
        String result = "";
        result = this.append(result, "KEY_probes", this.onProbeAddedProbesCheckBox.isSelected());
        result = this.append(result, "KEY_timeline", this.onProbeAddedTimelineCheckBox.isSelected());
        result = this.append(result, "KEY_details", this.onProbeAddedDetailsCheckBox.isSelected());
        return result;
    }

    void setOnProbeAdded2(String opened) {
        this.internalChange = true;
        if ("".equals(opened)) {
            this.onProbeAddedProbesCheckBox2.setSelected(false);
            this.onProbeAddedTimelineCheckBox2.setSelected(false);
            this.onProbeAddedDetailsCheckBox2.setSelected(false);
            this.onProbeAddedNothingCheckBox2.setSelected(true);
        } else {
            this.onProbeAddedProbesCheckBox2.setSelected(opened.contains("KEY_probes"));
            this.onProbeAddedTimelineCheckBox2.setSelected(opened.contains("KEY_timeline"));
            this.onProbeAddedDetailsCheckBox2.setSelected(opened.contains("KEY_details"));
            this.onProbeAddedNothingCheckBox2.setSelected(false);
        }
        this.internalChange = false;
    }

    String getOnProbeAdded2() {
        String result = "";
        result = this.append(result, "KEY_probes", this.onProbeAddedProbesCheckBox2.isSelected());
        result = this.append(result, "KEY_timeline", this.onProbeAddedTimelineCheckBox2.isSelected());
        result = this.append(result, "KEY_details", this.onProbeAddedDetailsCheckBox2.isSelected());
        return result;
    }

    void setOnSessionStart(String opened) {
        this.internalChange = true;
        if ("".equals(opened)) {
            this.onStartProbesCheckBox.setSelected(false);
            this.onStartTimelineCheckBox.setSelected(false);
            this.onStartDetailsCheckBox.setSelected(false);
            this.onStartNothingCheckBox.setSelected(true);
        } else {
            this.onStartProbesCheckBox.setSelected(opened.contains("KEY_probes"));
            this.onStartTimelineCheckBox.setSelected(opened.contains("KEY_timeline"));
            this.onStartDetailsCheckBox.setSelected(opened.contains("KEY_details"));
            this.onStartNothingCheckBox.setSelected(false);
        }
        this.internalChange = false;
    }

    String getOnSessionStart() {
        String result = "";
        result = this.append(result, "KEY_probes", this.onStartProbesCheckBox.isSelected());
        result = this.append(result, "KEY_timeline", this.onStartTimelineCheckBox.isSelected());
        result = this.append(result, "KEY_details", this.onStartDetailsCheckBox.isSelected());
        return result;
    }

    void setOnRowSelected(String opened) {
        this.internalChange = true;
        if ("".equals(opened)) {
            this.onRowSelectedProbesCheckBox.setSelected(false);
            this.onRowSelectedTimelineCheckBox.setSelected(false);
            this.onRowSelectedDetailsCheckBox.setSelected(false);
            this.onRowSelectedNothingCheckBox.setSelected(true);
        } else {
            this.onRowSelectedProbesCheckBox.setSelected(opened.contains("KEY_probes"));
            this.onRowSelectedTimelineCheckBox.setSelected(opened.contains("KEY_timeline"));
            this.onRowSelectedDetailsCheckBox.setSelected(opened.contains("KEY_details"));
            this.onRowSelectedNothingCheckBox.setSelected(false);
        }
        this.internalChange = false;
    }

    String getOnRowSelected() {
        String result = "";
        result = this.append(result, "KEY_probes", this.onRowSelectedProbesCheckBox.isSelected());
        result = this.append(result, "KEY_timeline", this.onRowSelectedTimelineCheckBox.isSelected());
        result = this.append(result, "KEY_details", this.onRowSelectedDetailsCheckBox.isSelected());
        return result;
    }

    void setOnRowSelected2(String opened) {
        this.internalChange = true;
        if ("".equals(opened)) {
            this.onRowSelectedProbesCheckBox2.setSelected(false);
            this.onRowSelectedTimelineCheckBox2.setSelected(false);
            this.onRowSelectedDetailsCheckBox2.setSelected(false);
            this.onRowSelectedNothingCheckBox2.setSelected(true);
        } else {
            this.onRowSelectedProbesCheckBox2.setSelected(opened.contains("KEY_probes"));
            this.onRowSelectedTimelineCheckBox2.setSelected(opened.contains("KEY_timeline"));
            this.onRowSelectedDetailsCheckBox2.setSelected(opened.contains("KEY_details"));
            this.onRowSelectedNothingCheckBox2.setSelected(false);
        }
        this.internalChange = false;
    }

    String getOnRowSelected2() {
        String result = "";
        result = this.append(result, "KEY_probes", this.onRowSelectedProbesCheckBox2.isSelected());
        result = this.append(result, "KEY_timeline", this.onRowSelectedTimelineCheckBox2.isSelected());
        result = this.append(result, "KEY_details", this.onRowSelectedDetailsCheckBox2.isSelected());
        return result;
    }

    void setZoomMode(String zoomMode) {
        this.internalChange = true;
        this.zoomModeCombo.setSelectedIndex(0);
        this.zoomModeCombo.setSelectedItem(zoomMode);
        this.internalChange = false;
    }

    String getZoomMode() {
        return this.zoomModeCombo.getSelectedItem().toString();
    }

    void setMouseWheelAction(String action) {
        this.internalChange = true;
        this.mouseWheelCombo.setSelectedIndex(0);
        this.mouseWheelCombo.setSelectedItem(action);
        this.internalChange = false;
    }

    String getMouseWheelAction() {
        return this.mouseWheelCombo.getSelectedItem().toString();
    }

    void setClearSelection(boolean clear) {
        this.clearSelectionsCheckBox.setSelected(clear);
    }

    boolean isClearSelection() {
        return this.clearSelectionsCheckBox.isSelected();
    }

    private String append(String result, String item, boolean append) {
        if (!append) {
            return result;
        }
        if (result.length() == 0) {
            result = result + item;
            return result;
        }
        result = result + "," + item;
        return result;
    }

    void update() {
        List<AbstractButton> selected;
        if (this.internalChange) {
            return;
        }
        if (this.refreshCombo.getSelectedIndex() == 0) {
            this.refreshCheckBox.setSelected(false);
            this.refreshCheckBox.setEnabled(false);
        } else {
            this.refreshCheckBox.setEnabled(true);
        }
        if (Utils.forceSpeed()) {
            this.rowsDecorationCombo.setSelectedItem(Boolean.FALSE);
            this.rowsDecorationCombo.setEnabled(false);
        }
        if ((selected = this.getSelected(this.initiallyOpenedPanel)).isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TracerOptionsPanel.this.setInitiallyOpened("KEY_probes");
                    TracerOptionsPanel.this.update();
                }
            });
        } else {
            this.initialProbesCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.initialProbesCheckBox));
            this.initialTimelineCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.initialTimelineCheckBox));
            this.initialDetailsCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.initialDetailsCheckBox));
        }
        if (this.onProbeAddedNothingCheckBox.isSelected()) {
            this.onProbeAddedProbesCheckBox.setSelected(false);
            this.onProbeAddedProbesCheckBox.setEnabled(false);
            this.onProbeAddedTimelineCheckBox.setSelected(false);
            this.onProbeAddedTimelineCheckBox.setEnabled(false);
            this.onProbeAddedDetailsCheckBox.setSelected(false);
            this.onProbeAddedDetailsCheckBox.setEnabled(false);
        } else {
            selected = this.getSelected(this.onProbeAddedPanel);
            if (selected.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TracerOptionsPanel.this.setOnProbeAdded("KEY_probes,KEY_timeline");
                        TracerOptionsPanel.this.update();
                    }
                });
            } else {
                this.onProbeAddedProbesCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onProbeAddedProbesCheckBox));
                this.onProbeAddedTimelineCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onProbeAddedTimelineCheckBox));
                this.onProbeAddedDetailsCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onProbeAddedDetailsCheckBox));
            }
        }
        if (this.onProbeAddedNothingCheckBox2.isSelected()) {
            this.onProbeAddedProbesCheckBox2.setSelected(false);
            this.onProbeAddedProbesCheckBox2.setEnabled(false);
            this.onProbeAddedTimelineCheckBox2.setSelected(false);
            this.onProbeAddedTimelineCheckBox2.setEnabled(false);
            this.onProbeAddedDetailsCheckBox2.setSelected(false);
            this.onProbeAddedDetailsCheckBox2.setEnabled(false);
        } else {
            selected = this.getSelected(this.onProbeAddedPanel2);
            if (selected.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TracerOptionsPanel.this.setOnProbeAdded2("KEY_probes");
                        TracerOptionsPanel.this.update();
                    }
                });
            } else {
                this.onProbeAddedProbesCheckBox2.setEnabled(selected.size() > 1 || !selected.contains(this.onProbeAddedProbesCheckBox2));
                this.onProbeAddedTimelineCheckBox2.setEnabled(selected.size() > 1 || !selected.contains(this.onProbeAddedTimelineCheckBox2));
                this.onProbeAddedDetailsCheckBox2.setEnabled(selected.size() > 1 || !selected.contains(this.onProbeAddedDetailsCheckBox2));
            }
        }
        if (this.onStartNothingCheckBox.isSelected()) {
            this.onStartProbesCheckBox.setSelected(false);
            this.onStartProbesCheckBox.setEnabled(false);
            this.onStartTimelineCheckBox.setSelected(false);
            this.onStartTimelineCheckBox.setEnabled(false);
            this.onStartDetailsCheckBox.setSelected(false);
            this.onStartDetailsCheckBox.setEnabled(false);
        } else {
            selected = this.getSelected(this.onStartOpenedPanel);
            if (selected.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TracerOptionsPanel.this.setOnSessionStart("KEY_timeline");
                        TracerOptionsPanel.this.update();
                    }
                });
            } else {
                this.onStartProbesCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onStartProbesCheckBox));
                this.onStartTimelineCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onStartTimelineCheckBox));
                this.onStartDetailsCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onStartDetailsCheckBox));
            }
        }
        if (this.onRowSelectedNothingCheckBox.isSelected()) {
            this.onRowSelectedProbesCheckBox.setSelected(false);
            this.onRowSelectedProbesCheckBox.setEnabled(false);
            this.onRowSelectedTimelineCheckBox.setSelected(false);
            this.onRowSelectedTimelineCheckBox.setEnabled(false);
            this.onRowSelectedDetailsCheckBox.setSelected(false);
            this.onRowSelectedDetailsCheckBox.setEnabled(false);
        } else {
            selected = this.getSelected(this.onRowSelectedPanel);
            if (selected.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TracerOptionsPanel.this.setOnRowSelected("KEY_timeline,KEY_details");
                        TracerOptionsPanel.this.update();
                    }
                });
            } else {
                this.onRowSelectedProbesCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onRowSelectedProbesCheckBox));
                this.onRowSelectedTimelineCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onRowSelectedTimelineCheckBox));
                this.onRowSelectedDetailsCheckBox.setEnabled(selected.size() > 1 || !selected.contains(this.onRowSelectedDetailsCheckBox));
            }
        }
        if (this.onRowSelectedNothingCheckBox2.isSelected()) {
            this.onRowSelectedProbesCheckBox2.setSelected(false);
            this.onRowSelectedProbesCheckBox2.setEnabled(false);
            this.onRowSelectedTimelineCheckBox2.setSelected(false);
            this.onRowSelectedTimelineCheckBox2.setEnabled(false);
            this.onRowSelectedDetailsCheckBox2.setSelected(false);
            this.onRowSelectedDetailsCheckBox2.setEnabled(false);
        } else {
            selected = this.getSelected(this.onRowSelectedPanel2);
            if (selected.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TracerOptionsPanel.this.setOnRowSelected2("KEY_timeline");
                        TracerOptionsPanel.this.update();
                    }
                });
            } else {
                this.onRowSelectedProbesCheckBox2.setEnabled(selected.size() > 1 || !selected.contains(this.onRowSelectedProbesCheckBox2));
                this.onRowSelectedTimelineCheckBox2.setEnabled(selected.size() > 1 || !selected.contains(this.onRowSelectedTimelineCheckBox2));
                this.onRowSelectedDetailsCheckBox2.setEnabled(selected.size() > 1 || !selected.contains(this.onRowSelectedDetailsCheckBox2));
            }
        }
        this.controller.changed();
    }

    private List<AbstractButton> getSelected(JPanel container) {
        ArrayList<AbstractButton> selected = new ArrayList<AbstractButton>();
        for (Component c : container.getComponents()) {
            if (!(c instanceof AbstractButton) || !((AbstractButton)c).isSelected()) continue;
            selected.add((AbstractButton)c);
        }
        return selected;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        SectionSeparator probesDefaultsSeparator = new SectionSeparator("Probes Settings");
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)probesDefaultsSeparator, c);
        JLabel probesDefaultsLabel = new JLabel("Initial appearance:");
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)probesDefaultsLabel, c);
        this.probesDefaultsCombo = new JComboBox(new String[]{"first expanded", "all expanded", "all collapsed"}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void selectedItemChanged() {
                TracerOptionsPanel.this.update();
                super.selectedItemChanged();
            }
        };
        probesDefaultsLabel.setLabelFor(this.probesDefaultsCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.probesDefaultsCombo, c);
        SectionSeparator timelineDefaultsSeparator = new SectionSeparator("Timeline Settings");
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(15, 0, 5, 0);
        this.add((Component)timelineDefaultsSeparator, c);
        JLabel refreshRateLabel = new JLabel("Sampling frequency:");
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)refreshRateLabel, c);
        Object[] refreshRates = new Integer[]{-1, 100, 200, 500, 1000, 2000, 5000, 10000};
        this.refreshCombo = new JComboBox(refreshRates){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void selectedItemChanged() {
                TracerOptionsPanel.this.update();
                super.selectedItemChanged();
            }
        };
        refreshRateLabel.setLabelFor(this.refreshCombo);
        this.refreshCombo.setRenderer(new CustomComboRenderer.Number(this.refreshCombo, "ms", true));
        this.refreshCombo.setEditable(false);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.refreshCombo, c);
        this.refreshCheckBox = new JCheckBox("Customizable in Tracer tab"){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = Math.min(d.height, ((TracerOptionsPanel)TracerOptionsPanel.this).refreshCombo.getPreferredSize().height);
                return d;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.refreshCheckBox, c);
        JLabel zoomModeLabel = new JLabel("Zoom mode:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)zoomModeLabel, c);
        this.zoomModeCombo = new JComboBox(new String[]{"fixed scale", "scale to fit"}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void selectedItemChanged() {
                TracerOptionsPanel.this.update();
                super.selectedItemChanged();
            }
        };
        zoomModeLabel.setLabelFor(this.zoomModeCombo);
        this.zoomModeCombo.setRenderer(new CustomComboRenderer.String(this.zoomModeCombo));
        this.zoomModeCombo.setEditable(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.zoomModeCombo, c);
        JLabel customizableZoomModeLabel = new JLabel("Customizable in Tracer tab");
        customizableZoomModeLabel.setEnabled(false);
        c.gridx = 2;
        c.gridy = 4;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 9, 3, 0);
        this.add((Component)customizableZoomModeLabel, c);
        JLabel mouseWheelLabel = new JLabel("Mouse wheel action:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)mouseWheelLabel, c);
        this.mouseWheelCombo = new JComboBox(new String[]{"zoom", "horizontal scroll", "vertical scroll"}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void selectedItemChanged() {
                TracerOptionsPanel.this.update();
                super.selectedItemChanged();
            }
        };
        mouseWheelLabel.setLabelFor(this.mouseWheelCombo);
        this.mouseWheelCombo.setRenderer(new CustomComboRenderer.String(this.mouseWheelCombo));
        this.mouseWheelCombo.setEditable(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.mouseWheelCombo, c);
        JLabel customizableMouseWheelLabel = new JLabel("Customizable in Tracer tab");
        customizableMouseWheelLabel.setEnabled(false);
        c.gridx = 2;
        c.gridy = 5;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 9, 3, 0);
        this.add((Component)customizableMouseWheelLabel, c);
        SectionSeparator timelineAppearanceSeparator = new SectionSeparator("Timeline Appearance");
        c = new GridBagConstraints();
        c.gridy = 6;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(15, 0, 5, 0);
        this.add((Component)timelineAppearanceSeparator, c);
        JLabel minMaxValsLabel = new JLabel("Show min/max values:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)minMaxValsLabel, c);
        this.minMaxValsCombo = new JComboBox(new Boolean[]{Boolean.TRUE, Boolean.FALSE}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        minMaxValsLabel.setLabelFor(this.minMaxValsCombo);
        this.minMaxValsCombo.setRenderer(new CustomComboRenderer.Boolean(this.minMaxValsCombo));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.minMaxValsCombo, c);
        JLabel customizableMinMaxValsLabel = new JLabel("Customizable in Tracer tab");
        customizableMinMaxValsLabel.setEnabled(false);
        c.gridx = 2;
        c.gridy = 7;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 9, 3, 0);
        this.add((Component)customizableMinMaxValsLabel, c);
        JLabel rowLegendLabel = new JLabel("Show row legend:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)rowLegendLabel, c);
        this.rowLegendCombo = new JComboBox(new Boolean[]{Boolean.TRUE, Boolean.FALSE}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        rowLegendLabel.setLabelFor(this.rowLegendCombo);
        this.rowLegendCombo.setRenderer(new CustomComboRenderer.Boolean(this.rowLegendCombo));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.rowLegendCombo, c);
        JLabel customizableRowLegendLabel = new JLabel("Customizable in Tracer tab");
        customizableRowLegendLabel.setEnabled(false);
        c.gridx = 2;
        c.gridy = 8;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 9, 3, 0);
        this.add((Component)customizableRowLegendLabel, c);
        JLabel rowsDecorationLabel = new JLabel("Rows decoration:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)rowsDecorationLabel, c);
        this.rowsDecorationCombo = new JComboBox(new Boolean[]{Boolean.TRUE, Boolean.FALSE}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        rowsDecorationLabel.setLabelFor(this.rowsDecorationCombo);
        this.rowsDecorationCombo.setRenderer(new CustomComboRenderer.Boolean(this.rowsDecorationCombo));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 9;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.rowsDecorationCombo, c);
        JLabel rowsSelectionLabel = new JLabel("Rows selection:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)rowsSelectionLabel, c);
        this.rowsSelectionCombo = new JComboBox(new String[]{"panel and chart", "panel only"}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        rowsSelectionLabel.setLabelFor(this.rowsSelectionCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 10;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.rowsSelectionCombo, c);
        SectionSeparator toolbarsBehaviorSeparator = new SectionSeparator("Toolbars Behavior");
        c = new GridBagConstraints();
        c.gridy = 11;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(15, 0, 5, 0);
        this.add((Component)toolbarsBehaviorSeparator, c);
        JLabel timelineToolbarLabel = new JLabel("Timeline toolbar:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 12;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)timelineToolbarLabel, c);
        this.timelineToolbarCombo = new JComboBox(new String[]{"always visible", "show with timeline"}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void selectedItemChanged() {
                TracerOptionsPanel.this.update();
                super.selectedItemChanged();
            }
        };
        timelineToolbarLabel.setLabelFor(this.timelineToolbarCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 12;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.timelineToolbarCombo, c);
        JLabel selectionToolbarLabel = new JLabel("Selection toolbar:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 13;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)selectionToolbarLabel, c);
        this.selectionToolbarCombo = new JComboBox(new String[]{"always visible", "show on selection", "always hidden"}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void selectedItemChanged() {
                TracerOptionsPanel.this.update();
                super.selectedItemChanged();
            }
        };
        selectionToolbarLabel.setLabelFor(this.selectionToolbarCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 13;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.selectionToolbarCombo, c);
        JLabel extraToolbarLabel = new JLabel("Export toolbar:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 14;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)extraToolbarLabel, c);
        this.extraToolbarCombo = new JComboBox(new String[]{"always visible", "show on data", "always hidden"}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void selectedItemChanged() {
                TracerOptionsPanel.this.update();
                super.selectedItemChanged();
            }
        };
        extraToolbarLabel.setLabelFor(this.extraToolbarCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 14;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 5, 3, 0);
        this.add((Component)this.extraToolbarCombo, c);
        SectionSeparator viewsBehaviorSeparator = new SectionSeparator("Views Behavior");
        c = new GridBagConstraints();
        c.gridy = 15;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(15, 0, 5, 0);
        this.add((Component)viewsBehaviorSeparator, c);
        JPanel viewsBehaviorPanel = new JPanel(new BorderLayout(0, 0));
        viewsBehaviorPanel.setOpaque(false);
        c = new GridBagConstraints();
        c.gridy = 16;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(8, 15, 0, 0);
        this.add((Component)viewsBehaviorPanel, c);
        final CardLayout viewsSettingsLayout = new CardLayout();
        final JPanel viewsSettingsContainer = new JPanel(viewsSettingsLayout);
        String INITIALLY_OPEN = "Initial appearance";
        String OPEN_PROBE_ADDED = "Probe added or removed";
        String OPEN_SESSION_STARTS = "Session started";
        String OPEN_ROW_SELECTED = "Row selected or unselected";
        final DefaultListModel<String> connectionTypeListModel = new DefaultListModel<String>();
        connectionTypeListModel.addElement("Initial appearance");
        connectionTypeListModel.addElement("Probe added or removed");
        connectionTypeListModel.addElement("Session started");
        connectionTypeListModel.addElement("Row selected or unselected");
        JList connectionTypeList = new JList(connectionTypeListModel);
        connectionTypeList.setVisibleRowCount(connectionTypeListModel.getSize());
        connectionTypeList.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(index0, index1);
                viewsSettingsLayout.show(viewsSettingsContainer, connectionTypeListModel.get(this.getMinSelectionIndex()).toString());
            }

            @Override
            public void removeSelectionInterval(int i1, int i2) {
            }
        });
        connectionTypeList.setSelectionMode(0);
        connectionTypeList.setSelectedIndex(0);
        final ListCellRenderer<String> defaultRenderer = connectionTypeList.getCellRenderer();
        Component rc = defaultRenderer.getListCellRendererComponent(connectionTypeList, "X", 0, false, false);
        connectionTypeList.setFixedCellHeight(rc.getPreferredSize().height + 2);
        connectionTypeList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return defaultRenderer.getListCellRendererComponent(list, " " + value + " ", index, isSelected, cellHasFocus);
            }
        });
        JScrollPane connectionTypeScroll = new JScrollPane(connectionTypeList, 20, 30){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        TracerOptionsPanel.createBorder(connectionTypeScroll, BorderFactory.createEmptyBorder(0, 0, 0, 10));
        viewsBehaviorPanel.add((Component)connectionTypeScroll, "West");
        viewsBehaviorPanel.add((Component)viewsSettingsContainer, "Center");
        this.initiallyOpenedPanel = new JPanel(new VerticalLayout(false));
        this.initiallyOpenedPanel.setBorder(TracerOptionsPanel.titledBorder("Select the views to open:"));
        this.initiallyOpenedPanel.setOpaque(false);
        this.initialProbesCheckBox = new JCheckBox("Probes"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.initiallyOpenedPanel.add(this.initialProbesCheckBox);
        this.initialTimelineCheckBox = new JCheckBox("Timeline"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.initiallyOpenedPanel.add(this.initialTimelineCheckBox);
        this.initialDetailsCheckBox = new JCheckBox("Details"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.initiallyOpenedPanel.add(this.initialDetailsCheckBox);
        viewsSettingsContainer.add((Component)this.initiallyOpenedPanel, "Initial appearance");
        this.onProbeAddedPanel = new JPanel(new VerticalLayout(false));
        this.onProbeAddedPanel.setBorder(TracerOptionsPanel.titledBorder("Open for selected probes:"));
        this.onProbeAddedPanel.setOpaque(false);
        this.onProbeAddedProbesCheckBox = new JCheckBox("Probes"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel.add(this.onProbeAddedProbesCheckBox);
        this.onProbeAddedTimelineCheckBox = new JCheckBox("Timeline"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel.add(this.onProbeAddedTimelineCheckBox);
        this.onProbeAddedDetailsCheckBox = new JCheckBox("Details"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel.add(this.onProbeAddedDetailsCheckBox);
        this.onProbeAddedNothingCheckBox = new JCheckBox("No change"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel.add(this.onProbeAddedNothingCheckBox);
        this.onProbeAddedPanel2 = new JPanel(new VerticalLayout(false));
        this.onProbeAddedPanel2.setBorder(TracerOptionsPanel.titledBorder("Open for no selection:"));
        this.onProbeAddedPanel2.setOpaque(false);
        this.onProbeAddedProbesCheckBox2 = new JCheckBox("Probes"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel2.add(this.onProbeAddedProbesCheckBox2);
        this.onProbeAddedTimelineCheckBox2 = new JCheckBox("Timeline"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel2.add(this.onProbeAddedTimelineCheckBox2);
        this.onProbeAddedDetailsCheckBox2 = new JCheckBox("Details"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel2.add(this.onProbeAddedDetailsCheckBox2);
        this.onProbeAddedNothingCheckBox2 = new JCheckBox("No change"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onProbeAddedPanel2.add(this.onProbeAddedNothingCheckBox2);
        JPanel onProbeAddedContainer = new JPanel(new GridLayout(1, 2));
        onProbeAddedContainer.add(this.onProbeAddedPanel);
        onProbeAddedContainer.add(this.onProbeAddedPanel2);
        viewsSettingsContainer.add((Component)onProbeAddedContainer, "Probe added or removed");
        this.onStartOpenedPanel = new JPanel(new VerticalLayout(false));
        this.onStartOpenedPanel.setBorder(TracerOptionsPanel.titledBorder("Select the views to open:"));
        this.onStartOpenedPanel.setOpaque(false);
        this.onStartProbesCheckBox = new JCheckBox("Probes"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onStartOpenedPanel.add(this.onStartProbesCheckBox);
        this.onStartTimelineCheckBox = new JCheckBox("Timeline"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onStartOpenedPanel.add(this.onStartTimelineCheckBox);
        this.onStartDetailsCheckBox = new JCheckBox("Details"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onStartOpenedPanel.add(this.onStartDetailsCheckBox);
        this.onStartNothingCheckBox = new JCheckBox("No change"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onStartOpenedPanel.add(this.onStartNothingCheckBox);
        viewsSettingsContainer.add((Component)this.onStartOpenedPanel, "Session started");
        this.onRowSelectedPanel = new JPanel(new VerticalLayout(false));
        this.onRowSelectedPanel.setBorder(TracerOptionsPanel.titledBorder("Open for selected rows:"));
        this.onRowSelectedPanel.setOpaque(false);
        this.onRowSelectedProbesCheckBox = new JCheckBox("Probes"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel.add(this.onRowSelectedProbesCheckBox);
        this.onRowSelectedTimelineCheckBox = new JCheckBox("Timeline"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel.add(this.onRowSelectedTimelineCheckBox);
        this.onRowSelectedDetailsCheckBox = new JCheckBox("Details"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel.add(this.onRowSelectedDetailsCheckBox);
        this.onRowSelectedNothingCheckBox = new JCheckBox("No change"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel.add(this.onRowSelectedNothingCheckBox);
        this.onRowSelectedPanel2 = new JPanel(new VerticalLayout(false));
        this.onRowSelectedPanel2.setBorder(TracerOptionsPanel.titledBorder("Open for no selection:"));
        this.onRowSelectedPanel2.setOpaque(false);
        this.onRowSelectedProbesCheckBox2 = new JCheckBox("Probes"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel2.add(this.onRowSelectedProbesCheckBox2);
        this.onRowSelectedTimelineCheckBox2 = new JCheckBox("Timeline"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel2.add(this.onRowSelectedTimelineCheckBox2);
        this.onRowSelectedDetailsCheckBox2 = new JCheckBox("Details"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel2.add(this.onRowSelectedDetailsCheckBox2);
        this.onRowSelectedNothingCheckBox2 = new JCheckBox("No change"){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TracerOptionsPanel.this.update();
            }
        };
        this.onRowSelectedPanel2.add(this.onRowSelectedNothingCheckBox2);
        JPanel onRowSelectedContainer = new JPanel(new GridLayout(1, 2));
        onRowSelectedContainer.add(this.onRowSelectedPanel);
        onRowSelectedContainer.add(this.onRowSelectedPanel2);
        viewsSettingsContainer.add((Component)onRowSelectedContainer, "Row selected or unselected");
        this.clearSelectionsCheckBox = new JCheckBox("Clear selected rows when closing Details view"){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 17;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 0;
        c.insets = new Insets(8, 15, 0, 0);
        this.add((Component)this.clearSelectionsCheckBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 100;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 0;
        this.add((Component)Spacer.create(), c);
    }

    private static Border titledBorder(String title) {
        String titleBorder = UIUtils.isWindowsLookAndFeel() ? " " : "";
        Border inner = BorderFactory.createEmptyBorder(0, 12, 3, 3);
        TitledBorder outer = BorderFactory.createTitledBorder(titleBorder + title);
        return BorderFactory.createCompoundBorder(outer, inner);
    }

    private static void createBorder(JComponent component, Border border) {
        Border cBorder = component.getBorder();
        if (cBorder == null) {
            component.setBorder(border);
        } else {
            component.setBorder(BorderFactory.createCompoundBorder(border, cBorder));
        }
    }
}

