/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public RelationMemberListTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void renderIcon(RelationMemberData member) {
        if (member == null) {
            this.setIcon(null);
        } else {
            this.setIcon(ImageProvider.get(member.getMemberType()));
        }
    }

    protected void renderRole(TwoColumnDiff.Item diffItem) {
        RelationMemberData member = (RelationMemberData)diffItem.value;
        String text = member == null ? "" : member.getRole();
        this.setText(text);
        this.setToolTipText(text);
        GuiHelper.setBackgroundReadable(this, diffItem.state.getColor());
    }

    protected void renderPrimitive(TwoColumnDiff.Item diffItem) {
        String text = "";
        RelationMemberData member = (RelationMemberData)diffItem.value;
        if (member != null) {
            switch (member.getMemberType()) {
                case NODE: {
                    text = I18n.tr("Node {0}", member.getMemberId());
                    break;
                }
                case WAY: {
                    text = I18n.tr("Way {0}", member.getMemberId());
                    break;
                }
                case RELATION: {
                    text = I18n.tr("Relation {0}", member.getMemberId());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.setText(text);
        this.setToolTipText(text);
        GuiHelper.setBackgroundReadable(this, diffItem.state.getColor());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        TwoColumnDiff.Item member = (TwoColumnDiff.Item)value;
        this.renderIcon((RelationMemberData)member.value);
        switch (column) {
            case 0: {
                this.renderRole(member);
                break;
            }
            case 1: {
                this.renderPrimitive(member);
                break;
            }
        }
        return this;
    }
}

