/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.jvxl.readers.PeriodicVolumeFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class CastepDensityReader
extends PeriodicVolumeFileReader {
    private int nFilePoints;
    private int nSkip;

    CastepDensityReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        this.isProgressive = false;
        this.isAngstroms = true;
    }

    @Override
    protected void gotoData(int n, int n2) throws Exception {
        this.nSkip = n;
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = new SB();
        while (this.rd() != null && this.line.indexOf(".") < 0) {
        }
        int n = 0;
        while (n < 3) {
            V3 v3 = this.volumetricVectors[n];
            v3.set(this.parseFloatStr(this.line), this.parseFloat(), this.parseFloat());
            this.rd();
            ++n;
        }
        this.nSurfaces = this.parseIntStr(this.rd());
        this.rd();
        this.nPointsX = this.parseIntStr(this.line);
        this.voxelCounts[0] = this.nPointsX + 1;
        this.nPointsY = this.parseInt();
        this.voxelCounts[1] = this.nPointsY + 1;
        this.nPointsZ = this.parseInt();
        this.voxelCounts[2] = this.nPointsZ + 1;
        this.nFilePoints = this.nPointsX++ * this.nPointsY++ * this.nPointsZ++;
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
        n = 0;
        while (n < 3) {
            this.volumetricVectors[n].scale(1.0f / (float)(this.voxelCounts[n] - 1));
            if (this.isAnisotropic) {
                this.setVectorAnisotropy(this.volumetricVectors[n]);
            }
            ++n;
        }
        while (this.rd().trim().length() > 0) {
        }
    }

    @Override
    protected void getPeriodicVoxels() throws Exception {
        int n;
        int n2;
        this.rd();
        String[] stringArray = this.getTokens();
        if (this.nSkip > 0 && stringArray.length < 3 + this.nSurfaces) {
            n2 = 0;
            while (n2 < this.nSkip) {
                n = 0;
                while (n < this.nFilePoints) {
                    this.rd();
                    ++n;
                }
                ++n2;
            }
            this.nSkip = 0;
        }
        if ((n2 = this.downsampleFactor) > 1) {
            n = 0;
            while (n < this.nFilePoints) {
                int n3 = this.parseIntStr(this.line) - 1;
                int n4 = this.parseInt() - 1;
                int n5 = this.parseInt() - 1;
                if (n3 % n2 == 0 && n4 % n2 == 0 && n5 % n2 == 0) {
                    if (this.nSkip > 0) {
                        this.skipPoints(this.nSkip);
                    }
                    this.voxelData[n3 / n2][n4 / n2][n5 / n2] = this.recordData(this.parseFloat());
                }
                this.rd();
                ++n;
            }
        } else {
            n = 0;
            while (n < this.nFilePoints) {
                int n6 = this.parseIntStr(this.line) - 1;
                int n7 = this.parseInt() - 1;
                int n8 = this.parseInt() - 1;
                if (this.nSkip > 0) {
                    this.skipPoints(this.nSkip);
                }
                this.voxelData[n6][n7][n8] = this.recordData(this.parseFloat());
                this.rd();
                ++n;
            }
        }
    }

    private void skipPoints(int n) {
        int n2 = this.next[0];
        int n3 = 0;
        while (n3 < n) {
            while (n2 < this.line.length() && PT.isWhitespace(this.line.charAt(n2++))) {
            }
            while (n2 < this.line.length() && !PT.isWhitespace(this.line.charAt(n2++))) {
            }
            ++n3;
        }
        this.next[0] = n2;
    }
}

