#############################################################################
##
#W  fakeNCurses.g         GAP 4 package `Browse'                 Frank Lübeck
##
#Y  Copyright (C) 2012,   Lehrstuhl D für Mathematik,  RWTH Aachen,   Germany
##
##  This file contains a fake record similar to the NCurses record which 
##  is generated by the kernel module of this package.
##  This is only needed if someone desperately wants to use parts of this
##  package but not compile and use the ncurses functionality. 
##  This can be done by setting the user preference 
##         SetUserPreference("browse", "loadwithoutncurses", true);
##  in the users gap.ini file. This is not recommended.
##  

NCurses := rec(
  ClearAll := function(arg) end,
  IsStdinATty := ReturnTrue,
  IsStdoutATty := ReturnTrue,
  KernelModuleVersion := "1.8",
  ResetCursor := ReturnTrue,
  attrs := rec(
      BLINK := 524288,
      BOLD := 2097152,
      ColorPairs := [ 256, 512, 768, 1024, 1280, 1536, 1792, 2048, 2304, 
          2560, 2816, 3072, 3328, 3584, 3840, 4096, 4352, 4608, 4864, 5120, 
          5376, 5632, 5888, 6144, 6400, 6656, 6912, 7168, 7424, 7680, 7936, 
          8192, 8448, 8704, 8960, 9216, 9472, 9728, 9984, 10240, 10496, 
          10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 
          13056, 13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 
          15360, 15616, 15872, 16128 ],
      DIM := 1048576,
      NORMAL := 0,
      REVERSE := 262144,
      STANDOUT := 65536,
      UNDERLINE := 131072,
      has_colors := true ),
  bottom_panel := ReturnTrue,
  cbreak := ReturnTrue,
  clearok := ReturnTrue,
  curs_set := function(arg) return 1; end,
  del_panel := ReturnTrue,
  delwin := ReturnTrue,
  doupdate := function(arg) Print("\nNo visual mode in Browse, compile\
  ncurses kernel module!\n"); return true; end,
  echo := ReturnTrue,
  endwin := ReturnTrue,
  getbegyx := function(arg) return [0,0]; end,
  getmaxyx := function(arg) return Reversed(SizeScreen()); end,
  getmouse := function(arg) return [0,0,1]; end,
  getyx := function(arg) return [0,0]; end,
  has_key := ReturnTrue,
  hide_panel := ReturnTrue,
  idlok := ReturnTrue,
  immedok := ReturnTrue,
  intrflush := ReturnTrue,
  isendwin := ReturnTrue,
  keypad := ReturnTrue,
  keys := rec(
      A1 := 348,
      A3 := 349,
      B2 := 350,
      BACKSPACE := 263,
      C1 := 351,
      C3 := 352,
      DC := 330,
      DOWN := 258,
      END := 360,
      ENTER := 343,
      F1 := 265,
      F10 := 274,
      F11 := 275,
      F12 := 276,
      F13 := 277,
      F14 := 278,
      F15 := 279,
      F16 := 280,
      F17 := 281,
      F18 := 282,
      F19 := 283,
      F2 := 266,
      F20 := 284,
      F21 := 285,
      F22 := 286,
      F23 := 287,
      F24 := 288,
      F3 := 267,
      F4 := 268,
      F5 := 269,
      F6 := 270,
      F7 := 271,
      F8 := 272,
      F9 := 273,
      HOME := 262,
      IC := 331,
      LEFT := 260,
      MOUSE := 409,
      NPAGE := 338,
      PPAGE := 339,
      REPLACE := 374,
      RIGHT := 261,
      STAB := 340,
      UP := 259 ),
  leaveok := ReturnTrue,
  lineDraw := rec(
      BLOCK := 4194352,
      BOARD := 4194408,
      BTEE := 4194422,
      BULLET := 4194430,
      CKBOARD := 4194401,
      DARROW := 4194350,
      DEGREE := 4194406,
      DIAMOND := 4194400,
      GEQUAL := 4194426,
      HLINE := 4194417,
      LANTERN := 4194409,
      LARROW := 4194348,
      LEQUAL := 4194425,
      LLCORNER := 4194413,
      LRCORNER := 4194410,
      LTEE := 4194420,
      NEQUAL := 4194428,
      PI := 4194427,
      PLMINUS := 4194407,
      PLUS := 4194414,
      RARROW := 4194347,
      RTEE := 4194421,
      S1 := 4194415,
      S3 := 4194416,
      S7 := 4194418,
      S9 := 4194419,
      STERLING := 4194429,
      TTEE := 4194423,
      UARROW := 4194349,
      ULCORNER := 4194412,
      URCORNER := 4194411,
      VLINE := 4194424 ),
  mouseinterval := function(arg) return 1; end,
  mousemask := function(arg) return rec(new:=[],old:=[]); end,
  move_panel := ReturnTrue,
  mvwin := ReturnTrue,
  napms := ReturnTrue,
  new_panel := function(arg) return 1; end,
  newwin := function(arg) return 1; end,
  nl := ReturnTrue,
  nocbreak := ReturnTrue,
  noecho := ReturnTrue,
  nonl := ReturnTrue,
  noraw := ReturnTrue,
  panel_above := function(arg) return 1; end,
  panel_below := function(arg) return 1; end,
  panellist := "\000\000\000\000",
  raw := ReturnTrue,
  resetty := ReturnTrue,
  savetty := ReturnTrue,
  scrollok := ReturnTrue,
  show_panel := ReturnTrue,
  top_panel := ReturnTrue,
  ungetch := ReturnTrue,
  update_panels := ReturnTrue,
  waddch := ReturnTrue,
  waddnstr := ReturnTrue,
  wattr_get := function(arg) return [0,0]; end,
  wattroff := ReturnTrue,
  wattron := ReturnTrue,
  wattrset := ReturnTrue,
  wbkgd := ReturnTrue,
  wbkgdset := ReturnTrue,
  wborder := ReturnTrue,
  wclear := ReturnTrue,
  wclrtobot := ReturnTrue,
  wclrtoeol := ReturnTrue,
  wenclose := ReturnTrue,
  werase := ReturnTrue,
  wgetch := function(arg) return 81; end,  # always 'Q'
  whline := function(arg) return 0; end,
  winch := function(arg) return 42; end,
  winlist := "\230\377\252\t",
  wmove := ReturnTrue,
  wrefresh := ReturnTrue,
  wtimeout := ReturnTrue,
  wvline := function(arg) return 0; end,
  WARNING := "fake record, ncurses.c not compiled!"
             );
