/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language.settings.providers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsBaseProvider;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IPathEntryContainerExtension;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsSerializableStorage;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.DefaultPathEntryStore;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.model.PathEntryUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PathEntryScannerInfoLanguageSettingsProvider
extends LanguageSettingsBaseProvider {
    @Override
    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        if (cfgDescription == null) {
            return null;
        }
        ICProjectDescription prjDescription = cfgDescription.getProjectDescription();
        if (prjDescription == null) {
            return null;
        }
        IProject project = prjDescription.getProject();
        ICProject cproject = CModelManager.getDefault().getCModel().getCProject((IResource)project);
        IPath projectPath = cproject.getPath();
        LinkedHashMap<Integer, Set<IPathEntry>> pathEntriesMap = new LinkedHashMap<Integer, Set<IPathEntry>>();
        pathEntriesMap.put(16, new LinkedHashSet());
        pathEntriesMap.put(64, new TreeSet<IPathEntry>(new Comparator<IPathEntry>(){

            @Override
            public int compare(IPathEntry macro1, IPathEntry macro2) {
                if (macro1 instanceof IMacroEntry && macro2 instanceof IMacroEntry) {
                    return ((IMacroEntry)macro1).getMacroName().compareTo(((IMacroEntry)macro2).getMacroName());
                }
                return 0;
            }
        }));
        pathEntriesMap.put(256, new LinkedHashSet());
        pathEntriesMap.put(512, new LinkedHashSet());
        pathEntriesMap.put(1, new LinkedHashSet());
        DefaultPathEntryStore pathEntryStore = new DefaultPathEntryStore(project);
        int typesMask = 849;
        try {
            IPathEntry[] storePathEntries;
            IPathEntry[] iPathEntryArray = storePathEntries = pathEntryStore.getRawPathEntries();
            int n = storePathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    IPathEntry storePathEntry = iPathEntryArray[n2];
                    if (storePathEntry instanceof IContainerEntry) {
                        try {
                            IPathEntryContainer container = PathEntryManager.getDefault().getPathEntryContainer((IContainerEntry)storePathEntry, cproject);
                            if (container == null) break block13;
                            IPathEntry[] pathEntries = null;
                            pathEntries = container instanceof IPathEntryContainerExtension ? ((IPathEntryContainerExtension)container).getPathEntries(rc.getFullPath(), typesMask) : container.getPathEntries();
                            if (pathEntries != null) {
                                IPathEntry[] iPathEntryArray2 = pathEntries;
                                int n3 = pathEntries.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IPathEntry pathEntry = iPathEntryArray2[n4];
                                    this.collectPathEntry(pathEntriesMap, projectPath, pathEntry);
                                    ++n4;
                                }
                            }
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    } else {
                        this.collectPathEntry(pathEntriesMap, projectPath, storePathEntry);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        LinkedHashSet<ICLanguageSettingEntry> lsEntries = new LinkedHashSet<ICLanguageSettingEntry>();
        for (Map.Entry entrySet : pathEntriesMap.entrySet()) {
            Set pathEntries = (Set)entrySet.getValue();
            for (IPathEntry pathEntry : pathEntries) {
                ICLanguageSettingEntry lsEntry = this.toLanguageSettingsEntry(pathEntry);
                if (lsEntry == null) continue;
                lsEntries.add(lsEntry);
            }
        }
        return LanguageSettingsSerializableStorage.getPooledList(new ArrayList<ICLanguageSettingEntry>(lsEntries));
    }

    private void collectPathEntry(LinkedHashMap<Integer, Set<IPathEntry>> pathEntriesMap, IPath projectPath, IPathEntry pathEntry) {
        switch (pathEntry.getEntryKind()) {
            case 1: 
            case 16: 
            case 64: 
            case 256: 
            case 512: {
                IPathEntry resolvedPathEntry = PathEntryUtil.cloneEntryAndExpand(projectPath, pathEntry);
                Set<IPathEntry> set = pathEntriesMap.get(resolvedPathEntry.getEntryKind());
                if (set == null) break;
                set.add(resolvedPathEntry);
            }
        }
    }

    private ICLanguageSettingEntry toLanguageSettingsEntry(IPathEntry pathEntry) {
        switch (pathEntry.getEntryKind()) {
            case 16: {
                IIncludeEntry includeEntry = (IIncludeEntry)pathEntry;
                return CDataUtil.createCIncludePathEntry(includeEntry.getFullIncludePath().toOSString(), includeEntry.isSystemInclude() ? 0 : 4);
            }
            case 64: {
                IMacroEntry macroEntry = (IMacroEntry)pathEntry;
                return CDataUtil.createCMacroEntry(macroEntry.getMacroName(), macroEntry.getMacroValue(), 0);
            }
            case 256: {
                IIncludeFileEntry includeFileEntry = (IIncludeFileEntry)pathEntry;
                return CDataUtil.createCIncludeFileEntry(includeFileEntry.getFullIncludeFilePath().toOSString(), 0);
            }
            case 512: {
                IMacroFileEntry macroFileEntry = (IMacroFileEntry)pathEntry;
                return CDataUtil.createCMacroFileEntry(macroFileEntry.getFullMacroFilePath().toOSString(), 0);
            }
            case 1: {
                ILibraryEntry libraryEntry = (ILibraryEntry)pathEntry;
                return CDataUtil.createCLibraryFileEntry(libraryEntry.getFullLibraryPath().toOSString(), 0);
            }
        }
        return null;
    }
}

