/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;

public final class JpaPreferences {
    private static final String ORIGINAL_PLUGIN_ID = JpaPreferences.getPlugin().getOriginalPluginID();
    private static final String ORIGINAL_PLUGIN_ID_ = String.valueOf(ORIGINAL_PLUGIN_ID) + '.';
    private static final String JPA_PLATFORM = String.valueOf(ORIGINAL_PLUGIN_ID_) + "platform";
    private static final String PLUGIN_ID = JpaPreferences.getPlugin().getPluginID();
    private static final String PLUGIN_ID_ = String.valueOf(PLUGIN_ID) + '.';
    private static final String DISCOVER_ANNOTATED_CLASSES = String.valueOf(PLUGIN_ID_) + "discoverAnnotatedClasses";
    private static final String METAMODEL_SOURCE_FOLDER = String.valueOf(PLUGIN_ID_) + "metamodelSourceFolderName";
    private static final String ENTITY_GEN = "entitygen";
    private static final String ENTITY_GEN_ = "entitygen.";
    private static final String ENTITY_GEN_DEFAULT_PACKAGE = "entitygen.DEFAULT_PACKAGE";
    private static final String ENTITY_GEN_DEFAULT_PACKAGE_DEFAULT = "model";
    private static final String USER_OVERRIDE_DEFAULT_CATALOG = "userOverrideDefaultCatalogName";
    private static final String USER_OVERRIDE_DEFAULT_SCHEMA = "userOverrideDefaultSchemaName";
    private static final String CONNECTION_PROFILE_NAME = "dataSource.connectionProfileName";
    private static final String JPQL_IDENTIFIER = "jpqlIdentifier";
    private static final String JPQL_IDENTIFIER_ = "jpqlIdentifier.";
    private static final String JPQL_IDENTIFIER_CASE = "jpqlIdentifier.CASE";
    private static final String JPQL_IDENTIFIER_CASE_VALUE_LOWERCASE = "lowercase";
    private static final String JPQL_IDENTIFIER_CASE_VALUE_UPPERCASE = "uppercase";
    private static final String JPQL_IDENTIFIER_CASE_DEFAULT = "lowercase";
    private static final String JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE = "jpqlIdentifier.MATCH_FIRST_CHARACTER_CASE";
    private static final boolean JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE_DEFAULT = true;
    private static final int JPQL_QUERY_TEXT_AREA_NUMBER_OF_LINES_DEFAULT = 5;
    private static final String JPQL_QUERY_TEXT_AREA_NUMBER_OF_LINES = "jpqlQueryEditorNumberOfLines";

    public static String getJpaPlatformID(IProject project) {
        return JpaPreferences.getPlugin().getPreference(project, JPA_PLATFORM);
    }

    public static void setJpaPlatformID(IProject project, String id) {
        JpaPreferences.getPlugin().setPreference(project, JPA_PLATFORM, id);
    }

    public static boolean getDiscoverAnnotatedClasses(IProject project) {
        return JpaPreferences.getPlugin().getBooleanPreference(project, DISCOVER_ANNOTATED_CLASSES);
    }

    public static void setDiscoverAnnotatedClasses(IProject project, boolean value) {
        JpaPreferences.getPlugin().setBooleanPreference(project, DISCOVER_ANNOTATED_CLASSES, value);
    }

    public static String getMetamodelSourceFolderName(IProject project) {
        return JpaPreferences.getPlugin().getPreference(project, METAMODEL_SOURCE_FOLDER);
    }

    public static void setMetamodelSourceFolderName(IProject project, String name) {
        JpaPreferences.getPlugin().setPreference(project, METAMODEL_SOURCE_FOLDER, name);
    }

    public static String getEntityGenDefaultPackageName(IProject project) {
        return JpaPreferences.getPlugin().getPreference(project, ENTITY_GEN_DEFAULT_PACKAGE);
    }

    public static void setEntityGenDefaultPackageName(IProject project, String name) {
        JpaPreferences.getPlugin().setPreference(project, ENTITY_GEN_DEFAULT_PACKAGE, name);
    }

    public static String getEntityGenDefaultPackageName() {
        return JpaPreferences.getPlugin().getPreference(ENTITY_GEN_DEFAULT_PACKAGE);
    }

    public static void setEntityGenDefaultPackageName(String name) {
        JpaPreferences.getPlugin().setPreference(ENTITY_GEN_DEFAULT_PACKAGE, name);
    }

    public static String getUserOverrideDefaultCatalog(IProject project) {
        return JpaPreferences.getPlugin().getPersistentProperty((IResource)project, USER_OVERRIDE_DEFAULT_CATALOG);
    }

    public static void setUserOverrideDefaultCatalog(IProject project, String catalog) {
        JpaPreferences.getPlugin().setPersistentProperty((IResource)project, USER_OVERRIDE_DEFAULT_CATALOG, catalog);
    }

    public static String getUserOverrideDefaultSchema(IProject project) {
        return JpaPreferences.getPlugin().getPersistentProperty((IResource)project, USER_OVERRIDE_DEFAULT_SCHEMA);
    }

    public static void setUserOverrideDefaultSchema(IProject project, String schema) {
        JpaPreferences.getPlugin().setPersistentProperty((IResource)project, USER_OVERRIDE_DEFAULT_SCHEMA, schema);
    }

    public static String getConnectionProfileName(IProject project) {
        return JpaPreferences.getPlugin().getPersistentProperty((IResource)project, CONNECTION_PROFILE_NAME);
    }

    public static void setConnectionProfileName(IProject project, String name) {
        JpaPreferences.getPlugin().setPersistentProperty((IResource)project, CONNECTION_PROFILE_NAME, name);
    }

    public static boolean getJpqlIdentifierLowercase() {
        return JpaPreferences.getJpqlIdentifierLowercase(JpaPreferences.getPlugin().getPreference(JPQL_IDENTIFIER_CASE));
    }

    public static boolean getJpqlIdentifierLowercaseDefault() {
        return JpaPreferences.getJpqlIdentifierLowercase("lowercase");
    }

    private static boolean getJpqlIdentifierLowercase(String value) {
        return ObjectTools.equals((Object)value, (Object)"lowercase");
    }

    public static void setJpqlIdentifierLowercase(boolean value) {
        JpaPreferences.getPlugin().setPreference(JPQL_IDENTIFIER_CASE, value ? "lowercase" : JPQL_IDENTIFIER_CASE_VALUE_UPPERCASE);
    }

    public static boolean getJpqlIdentifierMatchFirstCharacterCase() {
        return JpaPreferences.getPlugin().getBooleanPreference(JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE);
    }

    public static boolean getJpqlIdentifierMatchFirstCharacterCaseDefault() {
        return true;
    }

    public static void setJpqlIdentifierMatchFirstCharacterCase(boolean value) {
        JpaPreferences.getPlugin().setBooleanPreference(JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE, value);
    }

    public static int getJpqlQueryTextAreaNumberOfLinesDefault() {
        return 5;
    }

    public static int getJpqlQueryTextAreaNumberOfLines() {
        return JpaPreferences.getPlugin().getIntPreference(JPQL_QUERY_TEXT_AREA_NUMBER_OF_LINES, 5);
    }

    public static void setJpqlQueryTextAreaNumberOfLines(int value) {
        JpaPreferences.getPlugin().setIntPreference(JPQL_QUERY_TEXT_AREA_NUMBER_OF_LINES, value);
    }

    public static boolean getWorkspaceValidationOverridden(IProject project) {
        return JpaPreferences.getPlugin().getWorkspaceValidationPreferencesOverridden(project);
    }

    public static void setWorkspaceValidationOverridden(IProject project, boolean value) {
        JpaPreferences.getPlugin().setWorkspaceValidationPreferencesOverridden(project, value);
    }

    public static int getValidationMessageSeverity(IProject project, String messageID, int defaultSeverity) {
        return JpaPreferences.getPlugin().getValidationMessageSeverity(project, messageID, defaultSeverity);
    }

    public static int getValidationMessageSeverity(IProject project, String messageID) {
        return JpaPreferences.getPlugin().getValidationMessageSeverityPreference(project, messageID);
    }

    public static void setValidationMessageSeverity(IProject project, String messageID, int value) {
        JpaPreferences.getPlugin().setValidationMessageSeverityPreference(project, messageID, value);
    }

    public static int getValidationMessageSeverity(String messageID) {
        return JpaPreferences.getPlugin().getValidationMessageSeverityPreference(messageID);
    }

    public static void setValidationMessageSeverity(String messageID, int value) {
        JpaPreferences.getPlugin().setValidationMessageSeverityPreference(messageID, value);
    }

    public static void initializeDefaultPreferences() {
        JpaPreferences.getPlugin().setDefaultPreference(ENTITY_GEN_DEFAULT_PACKAGE, ENTITY_GEN_DEFAULT_PACKAGE_DEFAULT);
        JpaPreferences.getPlugin().setDefaultPreference(JPQL_IDENTIFIER_CASE, "lowercase");
        JpaPreferences.getPlugin().setBooleanDefaultPreference(JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE, true);
    }

    public static void removePreferences(IProject project) {
        JpaPreferences.getPlugin().removePreferences(project);
        JpaPreferences.getPlugin().removePersistentProperties((IResource)project);
    }

    public static void removePreferences() {
        JpaPreferences.getPlugin().removePreferences();
    }

    private static JptPlugin getPlugin() {
        return JptJpaCorePlugin.instance();
    }

    private JpaPreferences() {
        throw new UnsupportedOperationException();
    }
}

