/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.Field;
import org.apache.maven.index.context.IndexingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueArtifactFilterPostprocessor
implements ArtifactInfoFilter {
    public static final String COLLAPSED = "COLLAPSED";
    private final Set<Field> uniqueFields = new HashSet<Field>();
    private final Set<String> gas = new HashSet<String>();

    public UniqueArtifactFilterPostprocessor() {
    }

    public UniqueArtifactFilterPostprocessor(Set<Field> uniqueFields) {
        this.uniqueFields.addAll(uniqueFields);
    }

    @Override
    public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
        StringBuilder sb = new StringBuilder();
        for (Field field : this.uniqueFields) {
            sb.append(ai.getFieldValue(field)).append(":");
        }
        String key = sb.toString().substring(0, sb.length() - 1);
        if (this.gas.contains(key)) {
            return false;
        }
        this.gas.add(key);
        this.postprocess(ctx, ai);
        return true;
    }

    public void postprocess(IndexingContext ctx, ArtifactInfo ai) {
        for (Field field : ai.getFields()) {
            if (this.uniqueFields.contains(field)) continue;
            ai.setFieldValue(field, COLLAPSED);
        }
    }

    public void addField(Field field) {
        this.uniqueFields.add(field);
    }
}

