/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.linuxtools.internal.callgraph.core.ViewFactory;
import org.eclipse.ui.progress.UIJob;

public class StapUIJob
extends UIJob {
    private SystemTapParser parser;
    private String viewID;
    private SystemTapView viewer;

    public StapUIJob(String name, SystemTapParser parser, String viewID) {
        super(name);
        this.parser = parser;
        this.viewID = viewID;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        this.viewer = this.parser.getSecondaryID() != null && this.parser.getSecondaryID().length() > 0 ? ViewFactory.createView(this.viewID, this.parser.getSecondaryID()) : ViewFactory.createView(this.viewID);
        if (!this.viewer.setParser(this.parser)) {
            return Status.CANCEL_STATUS;
        }
        if (this.viewer.initializeView(this.getDisplay(), monitor) == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        if (!this.parser.realTime) {
            this.viewer.updateMethod();
        }
        this.viewer.setSourcePath(this.parser.getFile());
        this.viewer.setKillButtonEnabled(true);
        return Status.OK_STATUS;
    }

    public SystemTapView getViewer() {
        return this.viewer;
    }
}

