/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class TmfProviderManager {
    private static Map<Class<? extends ITmfEvent>, List<TmfEventProvider>> fProviders = new HashMap<Class<? extends ITmfEvent>, List<TmfEventProvider>>();

    private TmfProviderManager() {
    }

    public static synchronized <T extends ITmfEvent> void register(Class<T> eventType, TmfEventProvider provider) {
        List<TmfEventProvider> typeProviders = fProviders.get(eventType);
        if (typeProviders == null) {
            typeProviders = new ArrayList<TmfEventProvider>();
            fProviders.put(eventType, typeProviders);
        }
        typeProviders.add(provider);
    }

    public static synchronized <T extends ITmfEvent> void deregister(Class<T> eventType, TmfEventProvider provider) {
        List<TmfEventProvider> list = fProviders.get(eventType);
        if (list != null) {
            list.remove(provider);
            if (list.isEmpty()) {
                fProviders.remove(eventType);
            }
        }
    }

    public static TmfEventProvider[] getProviders(Class<? extends ITmfEvent> eventType) {
        List<TmfEventProvider> list = fProviders.get(eventType);
        if (list == null) {
            list = new ArrayList<TmfEventProvider>();
        }
        TmfEventProvider[] result = new TmfEventProvider[list.size()];
        return list.toArray(result);
    }

    public static TmfEventProvider[] getProviders(Class<? extends ITmfEvent> eventType, Class<? extends TmfEventProvider> providerType) {
        if (providerType == null) {
            return TmfProviderManager.getProviders(eventType);
        }
        TmfEventProvider[] list = TmfProviderManager.getProviders(eventType);
        ArrayList<TmfEventProvider> result = new ArrayList<TmfEventProvider>();
        if (list != null) {
            TmfEventProvider[] tmfEventProviderArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                TmfEventProvider provider = tmfEventProviderArray[n2];
                if (provider.getClass() == providerType) {
                    result.add(provider);
                }
                ++n2;
            }
        }
        TmfEventProvider[] array = new TmfEventProvider[result.size()];
        return result.toArray(array);
    }
}

