/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.ArrayUtils;

public abstract class JDBCTable<DATASOURCE extends DBPDataSource, CONTAINER extends DBSObjectContainer>
extends AbstractTable<DATASOURCE, CONTAINER>
implements DBSDataManipulator,
DBPSaveableObject {
    private static final Log log = Log.getLog(JDBCTable.class);
    private static final String DEFAULT_TABLE_ALIAS = "x";
    public static final int DEFAULT_READ_FETCH_SIZE = 10000;
    private boolean persisted;

    protected JDBCTable(CONTAINER container, boolean persisted) {
        super(container);
        this.persisted = persisted;
    }

    protected JDBCTable(CONTAINER container, DBSEntity source, boolean persisted) {
        super(container, source);
        this.persisted = persisted;
    }

    protected JDBCTable(CONTAINER container, @Nullable String tableName, boolean persisted) {
        super(container, tableName);
        this.persisted = persisted;
    }

    public abstract JDBCStructCache<CONTAINER, ? extends DBSEntity, ? extends DBSEntityAttribute> getCache();

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Override
    public int getSupportedFeatures() {
        int features = 458773;
        if (this.isTruncateSupported()) {
            features |= 0x80000;
        }
        return features;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        statistics = new DBCStatistics();
        hasLimits = firstRow >= 0L && maxRows > 0L;
        dataSource = session.getDataSource();
        monitor = session.getProgressMonitor();
        try {
            this.readRequiredMeta(monitor);
        }
        catch (DBException e) {
            JDBCTable.log.warn(e);
        }
        rowIdAttribute = (flags & 2L) != 0L ? DBUtils.getRowIdAttribute(this) : null;
        tableAlias = null;
        if ((dataFilter != null && dataFilter.hasConditions() || rowIdAttribute != null) && dataSource instanceof SQLDataSource && ((SQLDataSource)dataSource).getSQLDialect().supportsAliasInSelect()) {
            tableAlias = "x";
        }
        if (rowIdAttribute != null && tableAlias == null) {
            JDBCTable.log.warn("Can't query ROWID - table alias not supported");
            rowIdAttribute = null;
        }
        query = new StringBuilder(100);
        query.append("SELECT ");
        this.appendSelectSource(monitor, query, tableAlias, rowIdAttribute);
        query.append(" FROM ").append(this.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (tableAlias != null) {
            query.append(" ").append(tableAlias);
        }
        SQLUtils.appendQueryConditions(dataSource, query, tableAlias, dataFilter);
        SQLUtils.appendQueryOrder(dataSource, query, tableAlias, dataFilter);
        sqlQuery = query.toString();
        statistics.setQueryText(sqlQuery);
        statistics.addStatementsCount();
        monitor.subTask(ModelMessages.model_jdbc_fetch_table_data);
        try {
            var20_18 = null;
            var21_20 = null;
            try {
                dbStat = DBUtils.makeStatement(source, session, DBCStatementType.SCRIPT, sqlQuery, firstRow, maxRows);
                try {
                    if (monitor.isCanceled()) {
                        var32_23 = statistics;
                        while (true) {
                            dataReceiver.close();
                            return var32_23;
                        }
                    }
                    if (dbStat instanceof JDBCStatement && (fetchSize > 0 || maxRows > 0L)) {
                        v0 = useFetchSize = fetchSize > 0 || this.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.fetch.size") != false;
                        if (useFetchSize) {
                            if (fetchSize <= 0) {
                                fetchSize = 10000;
                            }
                            try {
                                dbStat.setResultsFetchSize(firstRow < 0L || maxRows <= 0L ? fetchSize : (int)(firstRow + maxRows));
                            }
                            catch (Exception e) {
                                JDBCTable.log.warn(e);
                            }
                        }
                    }
                    startTime = System.currentTimeMillis();
                    executeResult = dbStat.executeStatement();
                    statistics.setExecuteTime(System.currentTimeMillis() - startTime);
                    if (executeResult && (dbResult = dbStat.openResultSet()) != null && !monitor.isCanceled()) {
                        try {
                            dataReceiver.fetchStart(session, dbResult, firstRow, maxRows);
                            startTime = System.currentTimeMillis();
                            rowCount = 0L;
                            while (dbResult.nextRow()) {
                                if (monitor.isCanceled() || hasLimits && rowCount >= maxRows) break;
                                dataReceiver.fetchRow(session, dbResult);
                                if (++rowCount % 100L != 0L) continue;
                                monitor.subTask(String.valueOf(rowCount) + ModelMessages.model_jdbc__rows_fetched);
                                monitor.worked(100);
                            }
                            statistics.setFetchTime(System.currentTimeMillis() - startTime);
                            statistics.setRowsFetched(rowCount);
                        }
                        finally {
                            try {
                                dbResult.close();
                            }
                            catch (Throwable e) {
                                JDBCTable.log.error("Error closing result set", e);
                            }
                            try {
                                dataReceiver.fetchEnd(session, dbResult);
                            }
                            catch (Throwable e) {
                                JDBCTable.log.error("Error while finishing result set fetch", e);
                            }
                        }
                    }
                    var32_24 = statistics;
                    dataReceiver.close();
                    return var32_24;
                }
                catch (Throwable var20_19) {
                    throw var20_19;
                }
                finally {
                    if (dbStat == null) ** continue;
                    dbStat.close();
                }
            }
            catch (Throwable var21_21) {
                if (var20_18 == null) {
                    var20_18 = var21_21;
                } else if (var20_18 != var21_21) {
                    var20_18.addSuppressed(var21_21);
                }
                throw var20_18;
            }
        }
        catch (Throwable var31_36) {
            dataReceiver.close();
            throw var31_36;
        }
    }

    protected void appendSelectSource(DBRProgressMonitor monitor, StringBuilder query, String tableAlias, DBDPseudoAttribute rowIdAttribute) {
        if (rowIdAttribute != null) {
            query.append(tableAlias).append(".*");
            query.append(",").append(rowIdAttribute.translateExpression(tableAlias));
            if (rowIdAttribute.getAlias() != null) {
                query.append(" as ").append(rowIdAttribute.getAlias());
            }
        } else {
            if (tableAlias != null) {
                query.append(tableAlias).append(".");
            }
            query.append("*");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM ");
        query.append(this.getFullyQualifiedName(DBPEvaluationContext.DML));
        SQLUtils.appendQueryConditions(this.getDataSource(), query, null, dataFilter);
        monitor.subTask(ModelMessages.model_jdbc_fetch_table_row_count);
        Throwable throwable = null;
        Object var9_9 = null;
        try {
            DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);
            try {
                block21: {
                    dbStat.setStatementSource(source);
                    if (!dbStat.executeStatement()) {
                        return 0L;
                    }
                    DBCResultSet dbResult = dbStat.openResultSet();
                    if (dbResult == null) {
                        return 0L;
                    }
                    if (!dbResult.nextRow()) break block21;
                    Object result = dbResult.getAttributeValue(0);
                    if (result == null) {
                        return 0L;
                    }
                    if (result instanceof Number) {
                        long l = ((Number)result).longValue();
                        return l;
                    }
                    long l = Long.parseLong(result.toString());
                    return l;
                }
                return 0L;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (dbStat == null) return 0L;
                dbStat.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        this.readRequiredMeta(session.getProgressMonitor());
        return new ExecuteBatchImpl(attributes, keysReceiver, true){
            private boolean allNulls;

            @Override
            protected int getNextUsedParamIndex(Object[] attributeValues, int paramIndex) {
                DBSAttributeBase attribute = this.attributes[++paramIndex];
                while (DBUtils.isPseudoAttribute(attribute) || !this.allNulls && DBUtils.isNullValue(attributeValues[paramIndex])) {
                    ++paramIndex;
                }
                return paramIndex;
            }

            @Override
            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, Object[] attributeValues) throws DBCException {
                DBSAttributeBase attribute;
                StringBuilder query = new StringBuilder(200);
                query.append(JDBCTable.this.useUpsert(session) ? "UPSERT" : "INSERT").append(" INTO ").append(JDBCTable.this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" (");
                this.allNulls = true;
                int i = 0;
                while (i < this.attributes.length) {
                    if (!DBUtils.isNullValue(attributeValues[i])) {
                        this.allNulls = false;
                        break;
                    }
                    ++i;
                }
                boolean hasKey = false;
                int i2 = 0;
                while (i2 < this.attributes.length) {
                    attribute = this.attributes[i2];
                    if (!(DBUtils.isPseudoAttribute(attribute) || !this.allNulls && DBUtils.isNullValue(attributeValues[i2]))) {
                        if (hasKey) {
                            query.append(",");
                        }
                        hasKey = true;
                        query.append(JDBCTable.this.getAttributeName(attribute));
                    }
                    ++i2;
                }
                query.append(")\nVALUES (");
                hasKey = false;
                i2 = 0;
                while (i2 < this.attributes.length) {
                    attribute = this.attributes[i2];
                    if (!(DBUtils.isPseudoAttribute(attribute) || !this.allNulls && DBUtils.isNullValue(attributeValues[i2]))) {
                        if (hasKey) {
                            query.append(",");
                        }
                        hasKey = true;
                        query.append("?");
                    }
                    ++i2;
                }
                query.append(")");
                DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, this.keysReceiver != null);
                dbStat.setStatementSource(source);
                return dbStat;
            }

            @Override
            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                int paramIndex = 0;
                int k = 0;
                while (k < handlers.length) {
                    DBSAttributeBase attribute = this.attributes[k];
                    if (!(DBUtils.isPseudoAttribute(attribute) || !this.allNulls && DBUtils.isNullValue(attributeValues[k]))) {
                        handlers[k].bindValueObject(statement.getSession(), statement, attribute, paramIndex++, attributeValues[k]);
                    }
                    ++k;
                }
            }
        };
    }

    @Override
    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        if (this.useUpsert(session)) {
            return this.insertData(session, (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes), keysReceiver, source);
        }
        this.readRequiredMeta(session.getProgressMonitor());
        DBSAttributeBase[] attributes = (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes);
        return new ExecuteBatchImpl(attributes, keysReceiver, false){

            @Override
            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, Object[] attributeValues) throws DBCException {
                String tableAlias = null;
                SQLDialect dialect = ((SQLDataSource)session.getDataSource()).getSQLDialect();
                if (dialect.supportsAliasInUpdate()) {
                    tableAlias = JDBCTable.DEFAULT_TABLE_ALIAS;
                }
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ").append(JDBCTable.this.getFullyQualifiedName(DBPEvaluationContext.DML));
                if (tableAlias != null) {
                    query.append(' ').append(tableAlias);
                }
                query.append("\nSET ");
                boolean hasKey = false;
                DBSAttributeBase[] dBSAttributeBaseArray = updateAttributes;
                int n = updateAttributes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSAttributeBase attribute = dBSAttributeBaseArray[n2];
                    if (hasKey) {
                        query.append(",");
                    }
                    hasKey = true;
                    if (tableAlias != null) {
                        query.append(tableAlias).append(dialect.getStructSeparator());
                    }
                    query.append(JDBCTable.this.getAttributeName(attribute)).append("=?");
                    ++n2;
                }
                if (keyAttributes.length > 0) {
                    query.append("\nWHERE ");
                    hasKey = false;
                    int i = 0;
                    while (i < keyAttributes.length) {
                        DBSAttributeBase attribute = keyAttributes[i];
                        if (hasKey) {
                            query.append(" AND ");
                        }
                        hasKey = true;
                        JDBCTable.this.appendAttributeCriteria(tableAlias, dialect, query, attribute, attributeValues[updateAttributes.length + i]);
                        ++i;
                    }
                }
                DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, this.keysReceiver != null);
                dbStat.setStatementSource(source);
                return dbStat;
            }

            @Override
            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                int paramIndex = 0;
                int k = 0;
                while (k < handlers.length) {
                    DBSAttributeBase attribute = this.attributes[k];
                    if (k < updateAttributes.length || !DBUtils.isNullValue(attributeValues[k])) {
                        handlers[k].bindValueObject(statement.getSession(), statement, attribute, paramIndex++, attributeValues[k]);
                    }
                    ++k;
                }
            }
        };
    }

    @Override
    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        this.readRequiredMeta(session.getProgressMonitor());
        return new ExecuteBatchImpl(keyAttributes, null, false){

            @Override
            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, Object[] attributeValues) throws DBCException {
                String tableAlias = null;
                SQLDialect dialect = ((SQLDataSource)session.getDataSource()).getSQLDialect();
                if (dialect.supportsAliasInUpdate()) {
                    tableAlias = JDBCTable.DEFAULT_TABLE_ALIAS;
                }
                StringBuilder query = new StringBuilder();
                query.append("DELETE FROM ").append(JDBCTable.this.getFullyQualifiedName(DBPEvaluationContext.DML));
                if (tableAlias != null) {
                    query.append(' ').append(tableAlias);
                }
                if (keyAttributes.length > 0) {
                    query.append("\nWHERE ");
                    boolean hasKey = false;
                    int i = 0;
                    while (i < keyAttributes.length) {
                        if (hasKey) {
                            query.append(" AND ");
                        }
                        hasKey = true;
                        JDBCTable.this.appendAttributeCriteria(tableAlias, dialect, query, keyAttributes[i], attributeValues[i]);
                        ++i;
                    }
                }
                DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);
                dbStat.setStatementSource(source);
                return dbStat;
            }

            @Override
            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                int paramIndex = 0;
                int k = 0;
                while (k < handlers.length) {
                    DBSAttributeBase attribute = this.attributes[k];
                    if (!DBUtils.isNullValue(attributeValues[k])) {
                        handlers[k].bindValueObject(statement.getSession(), statement, attribute, paramIndex++, attributeValues[k]);
                    }
                    ++k;
                }
            }
        };
    }

    @Override
    public DBCStatistics truncateData(DBCSession session, DBCExecutionSource source) throws DBCException {
        if (!this.isTruncateSupported()) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DBSDataManipulator.ExecuteBatch batch = this.deleteData(session, new DBSAttributeBase[0], source);){
                batch.add(new Object[0]);
                return batch.execute(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        DBCStatistics statistics = new DBCStatistics();
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.subTask("Truncate data");
        Throwable throwable = null;
        Object var6_12 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, this.getTruncateTableQuery(), false, false, false);){
            dbStat.setStatementSource(source);
            dbStat.executeStatement();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        statistics.addStatementsCount();
        statistics.addExecuteTime();
        return statistics;
    }

    protected boolean isTruncateSupported() {
        return true;
    }

    protected String getTruncateTableQuery() {
        return "TRUNCATE TABLE " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    private boolean useUpsert(@NotNull DBCSession session) {
        SQLDialect dialect;
        SQLDialect sQLDialect = dialect = session.getDataSource() instanceof SQLDataSource ? ((SQLDataSource)session.getDataSource()).getSQLDialect() : null;
        return dialect instanceof JDBCSQLDialect && ((JDBCSQLDialect)dialect).supportsUpsertStatement();
    }

    private String getAttributeName(@NotNull DBSAttributeBase attribute) {
        return DBUtils.isPseudoAttribute(attribute) ? attribute.getName() : DBUtils.getObjectFullName(this.getDataSource(), attribute, DBPEvaluationContext.DML);
    }

    private void appendAttributeCriteria(@Nullable String tableAlias, SQLDialect dialect, StringBuilder query, DBSAttributeBase attribute, Object value) {
        DBDPseudoAttribute pseudoAttribute = null;
        if (DBUtils.isPseudoAttribute(attribute)) {
            if (attribute instanceof DBDAttributeBindingMeta) {
                pseudoAttribute = ((DBDAttributeBindingMeta)attribute).getPseudoAttribute();
            } else {
                log.error("Unsupported attribute argument: " + attribute);
            }
        }
        if (pseudoAttribute != null) {
            if (tableAlias == null) {
                tableAlias = this.getFullyQualifiedName(DBPEvaluationContext.DML);
            }
            String criteria = pseudoAttribute.translateExpression(tableAlias);
            query.append(criteria);
        } else {
            if (tableAlias != null) {
                query.append(tableAlias).append(dialect.getStructSeparator());
            }
            query.append(this.getAttributeName(attribute));
        }
        if (DBUtils.isNullValue(value)) {
            query.append(" IS NULL");
        } else {
            query.append("=?");
        }
    }

    private void readRequiredMeta(DBRProgressMonitor monitor) throws DBCException {
        try {
            this.getAttributes(monitor);
        }
        catch (DBException e) {
            throw new DBCException("Can't cache table columns", e);
        }
    }
}

