/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodecUtil;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.Marshallers;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.RegisteredSingletonDoNotUse;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationCodeGenerator;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public class AutoCodecProcessor
extends AbstractProcessor {
    private static final String PRINT_GENERATED_OPTION = "autocodec_print_generated";
    private ProcessingEnvironment env;
    private Marshallers marshallers;
    private static final Collection<Modifier> REQUIRED_SINGLETON_MODIFIERS = ImmutableList.of((Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL));

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of((Object)PRINT_GENERATED_OPTION);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoCodecUtil.ANNOTATION.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.env = processingEnv;
        this.marshallers = new Marshallers(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoCodecUtil.ANNOTATION)) {
            TypeSpec builtClass;
            AutoCodec annotation = element.getAnnotation(AutoCodecUtil.ANNOTATION);
            if (element instanceof TypeElement) {
                TypeSpec.Builder codecClassBuilder;
                TypeElement encodedType = (TypeElement)element;
                switch (annotation.strategy()) {
                    case INSTANTIATOR: {
                        codecClassBuilder = this.buildClassWithInstantiatorStrategy(encodedType, annotation);
                        break;
                    }
                    case AUTO_VALUE_BUILDER: {
                        codecClassBuilder = this.buildClassWithAutoValueBuilderStrategy(encodedType, annotation);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown strategy: " + annotation.strategy());
                    }
                }
                codecClassBuilder.addMethod(AutoCodecUtil.initializeGetEncodedClassMethod(encodedType, this.env).addStatement("return $T.class", new Object[]{TypeName.get((TypeMirror)this.env.getTypeUtils().erasure(encodedType.asType()))}).build());
                builtClass = codecClassBuilder.build();
            } else {
                builtClass = this.buildRegisteredSingletonClass((VariableElement)element);
            }
            String packageName = this.env.getElementUtils().getPackageOf(element).getQualifiedName().toString();
            try {
                JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)builtClass).build();
                file.writeTo(this.env.getFiler());
                if (!this.env.getOptions().containsKey(PRINT_GENERATED_OPTION)) continue;
                this.note("AutoCodec generated codec for " + element + ":\n" + file);
            }
            catch (IOException e) {
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate output file: " + e.getMessage());
            }
        }
        return true;
    }

    private TypeSpec buildRegisteredSingletonClass(VariableElement symbol) {
        Preconditions.checkState((boolean)symbol.getModifiers().containsAll(REQUIRED_SINGLETON_MODIFIERS), (Object)("Field must be static and final to be annotated with @AutoCodec: " + symbol));
        return TypeSpec.classBuilder((String)AutoCodecUtil.getGeneratedName(symbol, "RegisteredSingleton")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(RegisteredSingletonDoNotUse.class).addField(FieldSpec.builder((TypeName)TypeName.get((TypeMirror)symbol.asType()), (String)"REGISTERED_SINGLETON_INSTANCE_VAR_NAME_GLFKMEBDQFHOJQKEHHQPGMNQBOBFEJADCMDP", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$L", new Object[]{this.sanitizeTypeParameter(symbol.getEnclosingElement().asType()), symbol.getSimpleName()}).build()).build();
    }

    private TypeSpec.Builder buildClassWithInstantiatorStrategy(TypeElement encodedType, AutoCodec annotation) {
        ExecutableElement constructor = this.selectInstantiator(encodedType);
        List<? extends VariableElement> fields = constructor.getParameters();
        TypeSpec.Builder codecClassBuilder = AutoCodecUtil.initializeCodecClassBuilder(encodedType, this.env);
        if (encodedType.getAnnotation(AutoValue.class) == null) {
            this.initializeUnsafeOffsets(codecClassBuilder, encodedType, fields);
            codecClassBuilder.addMethod(this.buildSerializeMethodWithInstantiator(encodedType, fields, annotation));
        } else {
            codecClassBuilder.addMethod(this.buildSerializeMethodWithInstantiatorForAutoValue(encodedType, fields, annotation));
        }
        MethodSpec.Builder deserializeBuilder = AutoCodecUtil.initializeDeserializeMethodBuilder(encodedType, this.env);
        this.buildDeserializeBody(deserializeBuilder, fields);
        AutoCodecProcessor.addReturnNew(deserializeBuilder, encodedType, constructor, null, this.env);
        codecClassBuilder.addMethod(deserializeBuilder.build());
        return codecClassBuilder;
    }

    private TypeSpec.Builder buildClassWithAutoValueBuilderStrategy(TypeElement encodedType, AutoCodec annotation) {
        TypeElement builderType = this.findBuilderType(encodedType);
        List<ExecutableElement> getters = this.findGettersFromType(encodedType, builderType);
        ExecutableElement builderCreationMethod = this.findBuilderCreationMethod(encodedType, builderType);
        ExecutableElement buildMethod = this.findBuildMethod(encodedType, builderType);
        TypeSpec.Builder codecClassBuilder = AutoCodecUtil.initializeCodecClassBuilder(encodedType, this.env);
        MethodSpec.Builder serializeBuilder = AutoCodecUtil.initializeSerializeMethodBuilder(encodedType, annotation, this.env);
        for (ExecutableElement getter : getters) {
            this.marshallers.writeSerializationCode(new SerializationCodeGenerator.Context(serializeBuilder, getter.getReturnType(), AutoCodecProcessor.turnGetterIntoExpression(getter.getSimpleName().toString())));
        }
        codecClassBuilder.addMethod(serializeBuilder.build());
        MethodSpec.Builder deserializeBuilder = AutoCodecUtil.initializeDeserializeMethodBuilder(encodedType, this.env);
        String builderVarName = this.buildDeserializeBodyWithBuilder(encodedType, builderType, deserializeBuilder, getters, builderCreationMethod);
        AutoCodecProcessor.addReturnNew(deserializeBuilder, encodedType, buildMethod, builderVarName, this.env);
        codecClassBuilder.addMethod(deserializeBuilder.build());
        return codecClassBuilder;
    }

    private ExecutableElement selectInstantiator(TypeElement encodedType) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(encodedType.getEnclosedElements());
        Stream<ExecutableElement> factoryMethods = ElementFilter.methodsIn(encodedType.getEnclosedElements()).stream().filter(AutoCodecProcessor::hasInstantiatorAnnotation).peek(m -> this.verifyFactoryMethod(encodedType, (ExecutableElement)m));
        ImmutableList markedInstantiators = (ImmutableList)Stream.concat(constructors.stream().filter(AutoCodecProcessor::hasInstantiatorAnnotation), factoryMethods).collect(ImmutableList.toImmutableList());
        if (markedInstantiators.isEmpty()) {
            if (constructors.size() > 1) {
                throw new IllegalArgumentException(encodedType.getQualifiedName() + " has multiple constructors but no Instantiator annotation.");
            }
            return constructors.get(0);
        }
        if (markedInstantiators.size() == 1) {
            return (ExecutableElement)markedInstantiators.get(0);
        }
        throw new IllegalArgumentException(encodedType.getQualifiedName() + " has multiple Instantiator annotations.");
    }

    private static boolean hasInstantiatorAnnotation(Element elt) {
        return elt.getAnnotation(AutoCodec.Instantiator.class) != null;
    }

    private TypeElement findBuilderType(TypeElement encodedType) {
        TypeElement builderType = null;
        for (Element element : encodedType.getEnclosedElements()) {
            if (!(element instanceof TypeElement) || !element.getModifiers().contains((Object)Modifier.STATIC) || element.getAnnotation(AutoValue.Builder.class) == null) continue;
            if (builderType != null) {
                throw new IllegalArgumentException("Type " + encodedType + " had multiple inner classes annotated as @AutoValue.Builder: " + builderType + " and " + element);
            }
            builderType = (TypeElement)element;
        }
        if (builderType == null) {
            throw new IllegalArgumentException("Couldn't find @AutoValue.Builder-annotated static class inside " + encodedType);
        }
        return builderType;
    }

    private List<ExecutableElement> findGettersFromType(TypeElement encodedType, TypeElement builderTypeForFiltering) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : ElementFilter.methodsIn(this.env.getElementUtils().getAllMembers(encodedType))) {
            if (method.getModifiers().contains((Object)Modifier.STATIC) || !method.getModifiers().contains((Object)Modifier.ABSTRACT) || !method.getParameters().isEmpty() || method.getReturnType().getKind() == TypeKind.VOID || method.getReturnType().getKind().equals((Object)TypeKind.DECLARED) && builderTypeForFiltering.equals(this.env.getTypeUtils().asElement(method.getReturnType()))) continue;
            result.add(method);
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find any properties for " + encodedType);
        }
        return result;
    }

    private String getNameFromGetter(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        if (name.startsWith("get")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        if (name.startsWith("is")) {
            return name.substring(2, 3).toLowerCase() + name.substring(3);
        }
        return name;
    }

    private ExecutableElement findBuilderCreationMethod(TypeElement encodedType, TypeElement builderType) {
        ExecutableElement builderMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(this.env.getElementUtils().getAllMembers(encodedType))) {
            if (!method.getModifiers().contains((Object)Modifier.STATIC) || method.getModifiers().contains((Object)Modifier.ABSTRACT) || !method.getParameters().isEmpty() || !method.getReturnType().equals(builderType.asType())) continue;
            if (builderMethod != null) {
                throw new IllegalArgumentException("Type " + encodedType + " had multiple static methods to create an element of type " + builderType + ": " + builderMethod + " and " + method);
            }
            builderMethod = method;
        }
        if (builderMethod == null) {
            throw new IllegalArgumentException("Couldn't find builder creation method for " + encodedType + " and " + builderType);
        }
        return builderMethod;
    }

    private ExecutableElement findBuildMethod(TypeElement encodedType, TypeElement builderType) {
        ExecutableElement abstractBuildMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(this.env.getElementUtils().getAllMembers(builderType))) {
            if (method.getModifiers().contains((Object)Modifier.STATIC) || !method.getParameters().isEmpty() || !method.getReturnType().equals(encodedType.asType()) || !method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            if (abstractBuildMethod != null) {
                throw new IllegalArgumentException("Type " + builderType + " had multiple abstract methods to create an element of type " + encodedType + ": " + abstractBuildMethod + " and " + method);
            }
            abstractBuildMethod = method;
        }
        if (abstractBuildMethod == null) {
            throw new IllegalArgumentException("Couldn't find build method for " + encodedType + " and " + builderType);
        }
        return abstractBuildMethod;
    }

    private String buildDeserializeBodyWithBuilder(TypeElement encodedType, TypeElement builderType, MethodSpec.Builder builder, List<ExecutableElement> fields, ExecutableElement builderCreationMethod) {
        String builderVarName = "objectBuilder";
        builder.addStatement("$T $L = $T.$L()", new Object[]{builderCreationMethod.getReturnType(), builderVarName, encodedType, builderCreationMethod.getSimpleName()});
        for (ExecutableElement getter : fields) {
            String paramName = this.getNameFromGetter(getter) + "_";
            this.marshallers.writeDeserializationCode(new SerializationCodeGenerator.Context(builder, getter.getReturnType(), paramName));
            this.setValueInBuilder(builderType, getter, paramName, builderVarName, builder);
        }
        return builderVarName;
    }

    private void setValueInBuilder(TypeElement builderType, ExecutableElement getter, String paramName, String builderVarName, MethodSpec.Builder methodBuilder) {
        ExecutableElement setterMethod = this.findSetterGivenGetter(getter, builderType);
        methodBuilder.addStatement("$L.$L($L)", new Object[]{builderVarName, setterMethod.getSimpleName(), paramName});
    }

    private ExecutableElement findSetterGivenGetter(ExecutableElement getter, TypeElement builderType) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.env.getElementUtils().getAllMembers(builderType));
        String varName = this.getNameFromGetter(getter);
        TypeMirror type = getter.getReturnType();
        ImmutableSet setterNames = ImmutableSet.of((Object)varName, (Object)AutoCodecProcessor.addCamelCasePrefix(varName, "set"));
        ExecutableElement setterMethod = null;
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.STATIC) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !setterNames.contains((Object)method.getSimpleName().toString()) || !method.getReturnType().equals(builderType.asType()) || method.getParameters().size() != 1 || !this.env.getTypeUtils().isSubtype(type, ((VariableElement)Iterables.getOnlyElement(method.getParameters())).asType())) continue;
            if (setterMethod != null) {
                throw new IllegalArgumentException("Multiple setter methods for " + getter + " found in " + builderType + ": " + setterMethod + " and " + method);
            }
            setterMethod = method;
        }
        if (setterMethod != null) {
            return setterMethod;
        }
        throw new IllegalArgumentException(builderType + ": No setter found corresponding to getter " + getter.getSimpleName() + ", " + type);
    }

    private Relation findRelationWithGenerics(TypeMirror type1, TypeMirror type2) {
        if (type1.getKind() == TypeKind.TYPEVAR || type1.getKind() == TypeKind.WILDCARD || type2.getKind() == TypeKind.TYPEVAR || type2.getKind() == TypeKind.WILDCARD) {
            return Relation.EQUAL_TO;
        }
        if (this.env.getTypeUtils().isAssignable(type1, type2)) {
            if (this.env.getTypeUtils().isAssignable(type2, type1)) {
                return Relation.EQUAL_TO;
            }
            return Relation.INSTANCE_OF;
        }
        if (this.env.getTypeUtils().isAssignable(type2, type1)) {
            return Relation.SUPERTYPE_OF;
        }
        TypeMirror erasedType1 = this.env.getTypeUtils().erasure(type1);
        TypeMirror erasedType2 = this.env.getTypeUtils().erasure(type2);
        if (!this.env.getTypeUtils().isSameType(erasedType1, erasedType2)) {
            return Relation.UNRELATED_TO;
        }
        List<? extends TypeMirror> genericTypes1 = ((DeclaredType)type1).getTypeArguments();
        List<? extends TypeMirror> genericTypes2 = ((DeclaredType)type2).getTypeArguments();
        if (genericTypes1.size() != genericTypes2.size()) {
            return null;
        }
        for (int i = 0; i < genericTypes1.size(); ++i) {
            Relation result = this.findRelationWithGenerics(genericTypes1.get(i), genericTypes2.get(i));
            if (result == Relation.EQUAL_TO) continue;
            return Relation.UNRELATED_TO;
        }
        return Relation.EQUAL_TO;
    }

    private void verifyFactoryMethod(TypeElement encodedType, ExecutableElement elt) {
        boolean success = elt.getModifiers().contains((Object)Modifier.STATIC);
        if (success) {
            Relation equalityTest = this.findRelationWithGenerics(elt.getReturnType(), encodedType.asType());
            boolean bl = success = equalityTest == Relation.EQUAL_TO || equalityTest == Relation.INSTANCE_OF;
        }
        if (!success) {
            throw new IllegalArgumentException(encodedType.getQualifiedName() + " tags " + elt.getSimpleName() + " as an Instantiator, but it's not a valid factory method " + elt.getReturnType() + ", " + encodedType.asType());
        }
    }

    private MethodSpec buildSerializeMethodWithInstantiator(TypeElement encodedType, List<? extends VariableElement> fields, AutoCodec annotation) {
        MethodSpec.Builder serializeBuilder = AutoCodecUtil.initializeSerializeMethodBuilder(encodedType, annotation, this.env);
        for (VariableElement variableElement : fields) {
            Optional<FieldValueAndClass> hasField = this.getFieldByNameRecursive(encodedType, variableElement.getSimpleName().toString());
            if (hasField.isPresent()) {
                Preconditions.checkArgument((this.findRelationWithGenerics(hasField.get().value.asType(), variableElement.asType()) != Relation.UNRELATED_TO ? 1 : 0) != 0, (String)"%s: parameter %s's type %s is unrelated to corresponding field type %s", (Object)encodedType.getQualifiedName(), (Object)variableElement.getSimpleName(), (Object)variableElement.asType(), (Object)hasField.get().value.asType());
                TypeKind typeKind = variableElement.asType().getKind();
                serializeBuilder.addStatement("$T unsafe_$L = ($T) $T.getInstance().get$L(input, $L_offset)", new Object[]{this.sanitizeTypeParameter(variableElement.asType()), variableElement.getSimpleName(), this.sanitizeTypeParameter(variableElement.asType()), UnsafeProvider.class, typeKind.isPrimitive() ? AutoCodecProcessor.firstLetterUpper(typeKind.toString().toLowerCase()) : "Object", variableElement.getSimpleName()});
                this.marshallers.writeSerializationCode(new SerializationCodeGenerator.Context(serializeBuilder, variableElement.asType(), "unsafe_" + variableElement.getSimpleName()));
                continue;
            }
            this.addSerializeParameterWithGetter(encodedType, variableElement, serializeBuilder);
        }
        return serializeBuilder.build();
    }

    private TypeMirror sanitizeTypeParameter(TypeMirror type) {
        if (Marshallers.isVariableOrWildcardType(type)) {
            return this.env.getTypeUtils().erasure(type);
        }
        if (!(type instanceof DeclaredType)) {
            return type;
        }
        DeclaredType declaredType = (DeclaredType)type;
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (!Marshallers.isVariableOrWildcardType(typeMirror)) continue;
            return this.env.getTypeUtils().erasure(type);
        }
        return type;
    }

    private String findGetterForClass(VariableElement parameter, TypeElement type) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.env.getElementUtils().getAllMembers(type));
        ImmutableSet.Builder possibleGetterNamesBuilder = ImmutableSet.builder().add((Object)parameter.getSimpleName().toString());
        if (parameter.asType().getKind() == TypeKind.BOOLEAN) {
            possibleGetterNamesBuilder.add((Object)AutoCodecProcessor.addCamelCasePrefix(parameter.getSimpleName().toString(), "is"));
        } else {
            possibleGetterNamesBuilder.add((Object)AutoCodecProcessor.addCamelCasePrefix(parameter.getSimpleName().toString(), "get"));
        }
        ImmutableSet possibleGetterNames = possibleGetterNamesBuilder.build();
        for (ExecutableElement element : methods) {
            if (element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.PRIVATE) || !possibleGetterNames.contains((Object)element.getSimpleName().toString()) || this.findRelationWithGenerics(parameter.asType(), element.getReturnType()) == Relation.UNRELATED_TO) continue;
            return element.getSimpleName().toString();
        }
        throw new IllegalArgumentException(type + ": No getter found corresponding to parameter " + parameter.getSimpleName() + ", " + parameter.asType());
    }

    private static String addCamelCasePrefix(String name, String prefix) {
        return prefix + AutoCodecProcessor.firstLetterUpper(name);
    }

    private static String firstLetterUpper(String str) {
        return Character.toUpperCase(str.charAt(0)) + (str.length() == 1 ? "" : str.substring(1));
    }

    private void addSerializeParameterWithGetter(TypeElement encodedType, VariableElement parameter, MethodSpec.Builder serializeBuilder) {
        String getter = AutoCodecProcessor.turnGetterIntoExpression(this.findGetterForClass(parameter, encodedType));
        this.marshallers.writeSerializationCode(new SerializationCodeGenerator.Context(serializeBuilder, parameter.asType(), getter));
    }

    private static String turnGetterIntoExpression(String getterName) {
        return "input." + getterName + "()";
    }

    private MethodSpec buildSerializeMethodWithInstantiatorForAutoValue(TypeElement encodedType, List<? extends VariableElement> fields, AutoCodec annotation) {
        MethodSpec.Builder serializeBuilder = AutoCodecUtil.initializeSerializeMethodBuilder(encodedType, annotation, this.env);
        for (VariableElement variableElement : fields) {
            this.addSerializeParameterWithGetter(encodedType, variableElement, serializeBuilder);
        }
        return serializeBuilder.build();
    }

    private void buildDeserializeBody(MethodSpec.Builder builder, List<? extends VariableElement> fields) {
        for (VariableElement variableElement : fields) {
            String paramName = variableElement.getSimpleName() + "_";
            this.marshallers.writeDeserializationCode(new SerializationCodeGenerator.Context(builder, variableElement.asType(), paramName));
        }
    }

    private static void addReturnNew(MethodSpec.Builder builder, TypeElement type, ExecutableElement instantiator, Object builderVar, ProcessingEnvironment env) {
        List<? extends TypeMirror> allThrown = instantiator.getThrownTypes();
        if (!allThrown.isEmpty()) {
            builder.beginControlFlow("try", new Object[0]);
        }
        TypeName typeName = TypeName.get((TypeMirror)env.getTypeUtils().erasure(type.asType()));
        String parameters = instantiator.getParameters().stream().map(AutoCodecProcessor::handleFromParameter).collect(Collectors.joining(", "));
        if (instantiator.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
            builder.addStatement("return new $T($L)", new Object[]{typeName, parameters});
        } else if (builderVar == null) {
            builder.addStatement("return $T.$L($L)", new Object[]{typeName, instantiator.getSimpleName(), parameters});
        } else {
            builder.addStatement("return $L.$L($L)", new Object[]{builderVar, instantiator.getSimpleName(), parameters});
        }
        if (!allThrown.isEmpty()) {
            for (TypeMirror typeMirror : allThrown) {
                builder.nextControlFlow("catch ($T e)", new Object[]{TypeName.get((TypeMirror)typeMirror)});
                builder.addStatement("throw new $T(\"$L instantiator threw an exception\", e)", new Object[]{SerializationException.class, type.getQualifiedName()});
            }
            builder.endControlFlow();
        }
    }

    private static String handleFromParameter(VariableElement parameter) {
        return parameter.getSimpleName() + "_";
    }

    private void initializeUnsafeOffsets(TypeSpec.Builder builder, TypeElement encodedType, List<? extends VariableElement> parameters) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        for (VariableElement variableElement : parameters) {
            Optional<FieldValueAndClass> field = this.getFieldByNameRecursive(encodedType, variableElement.getSimpleName().toString());
            if (!field.isPresent()) continue;
            builder.addField(TypeName.LONG, variableElement.getSimpleName() + "_offset", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.beginControlFlow("try", new Object[0]);
            constructor.addStatement("this.$L_offset = $T.getInstance().objectFieldOffset($T.class.getDeclaredField(\"$L\"))", new Object[]{variableElement.getSimpleName(), UnsafeProvider.class, ClassName.get((TypeElement)field.get().declaringClassType), variableElement.getSimpleName()});
            constructor.nextControlFlow("catch ($T e)", new Object[]{NoSuchFieldException.class});
            constructor.addStatement("throw new $T(e)", new Object[]{IllegalStateException.class});
            constructor.endControlFlow();
        }
        builder.addMethod(constructor.build());
    }

    private Optional<FieldValueAndClass> getFieldByNameRecursive(TypeElement type, String name) {
        Optional<VariableElement> field = ElementFilter.fieldsIn(type.getEnclosedElements()).stream().filter(f -> f.getSimpleName().contentEquals(name)).findAny();
        if (field.isPresent()) {
            return Optional.of(new FieldValueAndClass(field.get(), type));
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            return this.getFieldByNameRecursive((TypeElement)this.env.getTypeUtils().asElement(this.env.getTypeUtils().erasure(type.getSuperclass())), name);
        }
        return Optional.empty();
    }

    private boolean matchesType(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSameType(type, this.env.getElementUtils().getTypeElement(clazz.getCanonicalName()).asType());
    }

    private void note(String note) {
        this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, note);
    }

    private static class FieldValueAndClass {
        final VariableElement value;
        final TypeElement declaringClassType;

        FieldValueAndClass(VariableElement value, TypeElement declaringClassType) {
            this.value = value;
            this.declaringClassType = declaringClassType;
        }
    }

    private static enum Relation {
        INSTANCE_OF,
        EQUAL_TO,
        SUPERTYPE_OF,
        UNRELATED_TO;

    }
}

