(function() {
  var scopesByFenceName;

  scopesByFenceName = {
    'bash': 'source.shell',
    'sh': 'source.shell',
    'powershell': 'source.powershell',
    'ps1': 'source.powershell',
    'c': 'source.c',
    'c++': 'source.cpp',
    'cpp': 'source.cpp',
    'coffee': 'source.coffee',
    'coffee-script': 'source.coffee',
    'coffeescript': 'source.coffee',
    'cs': 'source.cs',
    'csharp': 'source.cs',
    'css': 'source.css',
    'sass': 'source.sass',
    'scss': 'source.css.scss',
    'erlang': 'source.erl',
    'go': 'source.go',
    'html': 'text.html.basic',
    'java': 'source.java',
    'javascript': 'source.js',
    'js': 'source.js',
    'json': 'source.json',
    'less': 'source.less',
    'mustache': 'text.html.mustache',
    'objc': 'source.objc',
    'objective-c': 'source.objc',
    'php': 'text.html.php',
    'py': 'source.python',
    'python': 'source.python',
    'rb': 'source.ruby',
    'ruby': 'source.ruby',
    'text': 'text.plain',
    'toml': 'source.toml',
    'ts': 'source.ts',
    'typescript': 'source.ts',
    'xml': 'text.xml',
    'yaml': 'source.yaml',
    'yml': 'source.yaml'
  };

  module.exports = {
    scopeForFenceName: function(fenceName) {
      var ref;
      fenceName = fenceName.toLowerCase();
      return (ref = scopesByFenceName[fenceName]) != null ? ref : "source." + fenceName;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
