"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Git is asynchronously initializing a new repository in this working directory.
 */
class Initializing extends _state["default"] {
  async start() {
    await this.doInit(this.workdir());
    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directInit(workdir) {
    return this.git().init(workdir);
  }

}

exports["default"] = Initializing;

_state["default"].register(Initializing);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluaXRpYWxpemluZy5qcyJdLCJuYW1lcyI6WyJJbml0aWFsaXppbmciLCJTdGF0ZSIsInN0YXJ0IiwiZG9Jbml0Iiwid29ya2RpciIsInRyYW5zaXRpb25UbyIsInNob3dHaXRUYWJMb2FkaW5nIiwiZGlyZWN0SW5pdCIsImdpdCIsImluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7O0FBRUE7OztBQUdlLE1BQU1BLFlBQU4sU0FBMkJDLGlCQUEzQixDQUFpQztBQUM5QyxRQUFNQyxLQUFOLEdBQWM7QUFDWixVQUFNLEtBQUtDLE1BQUwsQ0FBWSxLQUFLQyxPQUFMLEVBQVosQ0FBTjtBQUVBLFVBQU0sS0FBS0MsWUFBTCxDQUFrQixTQUFsQixDQUFOO0FBQ0Q7O0FBRURDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxFQUFBQSxVQUFVLENBQUNILE9BQUQsRUFBVTtBQUNsQixXQUFPLEtBQUtJLEdBQUwsR0FBV0MsSUFBWCxDQUFnQkwsT0FBaEIsQ0FBUDtBQUNEOztBQWI2Qzs7OztBQWdCaERILGtCQUFNUyxRQUFOLENBQWVWLFlBQWYiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNy4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBHaXQgaXMgYXN5bmNocm9ub3VzbHkgaW5pdGlhbGl6aW5nIGEgbmV3IHJlcG9zaXRvcnkgaW4gdGhpcyB3b3JraW5nIGRpcmVjdG9yeS5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgSW5pdGlhbGl6aW5nIGV4dGVuZHMgU3RhdGUge1xuICBhc3luYyBzdGFydCgpIHtcbiAgICBhd2FpdCB0aGlzLmRvSW5pdCh0aGlzLndvcmtkaXIoKSk7XG5cbiAgICBhd2FpdCB0aGlzLnRyYW5zaXRpb25UbygnTG9hZGluZycpO1xuICB9XG5cbiAgc2hvd0dpdFRhYkxvYWRpbmcoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBkaXJlY3RJbml0KHdvcmtkaXIpIHtcbiAgICByZXR1cm4gdGhpcy5naXQoKS5pbml0KHdvcmtkaXIpO1xuICB9XG59XG5cblN0YXRlLnJlZ2lzdGVyKEluaXRpYWxpemluZyk7XG4iXX0=