"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareReviewsController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _reviewsView = _interopRequireDefault(require("../views/reviews-view"));

var _prCheckoutController = _interopRequireDefault(require("../controllers/pr-checkout-controller"));

var _addPrReview = _interopRequireDefault(require("../mutations/add-pr-review"));

var _addPrReviewComment = _interopRequireDefault(require("../mutations/add-pr-review-comment"));

var _submitPrReview = _interopRequireDefault(require("../mutations/submit-pr-review"));

var _deletePrReview = _interopRequireDefault(require("../mutations/delete-pr-review"));

var _resolveReviewThread = _interopRequireDefault(require("../mutations/resolve-review-thread"));

var _unresolveReviewThread = _interopRequireDefault(require("../mutations/unresolve-review-thread"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Milliseconds to leave scrollToThreadID non-null before reverting.
const FLASH_DELAY = 1500;

class BareReviewsController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openFile", async (filePath, lineNumber) => {
      await this.props.workspace.open(filePath, {
        initialLine: lineNumber - 1,
        initialColumn: 0,
        pending: true
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-file', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openDiff", async (filePath, lineNumber) => {
      const item = await this.getPRDetailItem();
      item.openFilesTab({
        changedFilePath: filePath,
        changedFilePosition: lineNumber
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-diff', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "openPR", async () => {
      await this.getPRDetailItem();
      (0, _reporterProxy.addEvent)('reviews-dock-open-pr', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "getPRDetailItem", () => {
      return this.props.workspace.open(_issueishDetailItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir
      }), {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "moreContext", () => {
      this.setState(prev => ({
        contextLines: prev.contextLines + 1
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-more-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "lessContext", () => {
      this.setState(prev => ({
        contextLines: Math.max(prev.contextLines - 1, 1)
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-less-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openIssueish", async (owner, repo, number) => {
      const host = this.props.endpoint.getHost();
      const homeRepository = (await this.props.localRepository.hasGitHubRemote(host, owner, repo)) ? this.props.localRepository : (await this.props.workdirContextPool.getMatchingContext(host, owner, repo)).getRepository();

      const uri = _issueishDetailItem["default"].buildURI({
        host,
        owner,
        repo,
        number,
        workdir: homeRepository.getWorkingDirectoryPath()
      });

      return this.props.workspace.open(uri, {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "showSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: false
    }, resolve)));

    _defineProperty(this, "showComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: false
    }, resolve)));

    _defineProperty(this, "showThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen.add(commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "hideThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen["delete"](commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "resolveThread", async thread => {
      if (thread.viewerCanResolve) {
        // optimistically hide the thread to avoid jankiness;
        // if the operation fails, the onError callback will revert it.
        this.hideThreadID(thread.id);

        try {
          await (0, _resolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          (0, _reporterProxy.addEvent)('resolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.showThreadID(thread.id);
          this.props.reportMutationErrors('Unable to resolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "unresolveThread", async thread => {
      if (thread.viewerCanUnresolve) {
        try {
          await (0, _unresolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          (0, _reporterProxy.addEvent)('unresolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.props.reportMutationErrors('Unable to unresolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "addSingleComment", async (commentBody, threadID, replyToID, path, position, callbacks = {}) => {
      let pendingReviewID = null;

      try {
        this.setState({
          postingToThreadID: threadID
        });
        const reviewResult = await (0, _addPrReview["default"])(this.props.relay.environment, {
          pullRequestID: this.props.pullRequest.id,
          viewerID: this.props.viewer.id
        });
        const reviewID = reviewResult.addPullRequestReview.reviewEdge.node.id;
        pendingReviewID = reviewID;
        const commentPromise = (0, _addPrReviewComment["default"])(this.props.relay.environment, {
          body: commentBody,
          inReplyTo: replyToID,
          reviewID,
          threadID,
          viewerID: this.props.viewer.id,
          path,
          position
        });

        if (callbacks.didSubmitComment) {
          callbacks.didSubmitComment();
        }

        await commentPromise;
        pendingReviewID = null;
        await (0, _submitPrReview["default"])(this.props.relay.environment, {
          event: 'COMMENT',
          reviewID
        });
        (0, _reporterProxy.addEvent)('add-single-comment', {
          "package": 'github'
        });
      } catch (error) {
        if (callbacks.didFailComment) {
          callbacks.didFailComment();
        }

        if (pendingReviewID !== null) {
          try {
            await (0, _deletePrReview["default"])(this.props.relay.environment, {
              reviewID: pendingReviewID,
              pullRequestID: this.props.pullRequest.id
            });
          } catch (e) {
            /* istanbul ignore else */
            if (error.errors && e.errors) {
              error.errors.push(...e.errors);
            } else {
              // eslint-disable-next-line no-console
              console.warn('Unable to delete pending review', e);
            }
          }
        }

        this.props.reportMutationErrors('Unable to submit your comment', error);
      } finally {
        this.setState({
          postingToThreadID: null
        });
      }
    });

    this.state = {
      contextLines: 4,
      postingToThreadID: null,
      scrollToThreadID: this.props.initThreadID,
      summarySectionOpen: true,
      commentSectionOpen: true,
      threadIDsOpen: new Set(this.props.initThreadID ? [this.props.initThreadID] : [])
    };
  }

  componentDidMount() {
    const {
      scrollToThreadID
    } = this.state;

    if (scrollToThreadID) {
      setTimeout(() => this.setState({
        scrollToThreadID: null
      }), FLASH_DELAY);
    }
  }

  componentDidUpdate(prevProps) {
    const {
      initThreadID
    } = this.props;

    if (initThreadID && initThreadID !== prevProps.initThreadID) {
      this.setState(prev => {
        prev.threadIDsOpen.add(initThreadID);
        return {
          commentSectionOpen: true,
          scrollToThreadID: initThreadID
        };
      }, () => {
        setTimeout(() => this.setState({
          scrollToThreadID: null
        }), FLASH_DELAY);
      });
    }
  }

  render() {
    return _react["default"].createElement(_prCheckoutController["default"], {
      repository: this.props.repository,
      pullRequest: this.props.pullRequest,
      localRepository: this.props.localRepository,
      isAbsent: this.props.isAbsent,
      isLoading: this.props.isLoading,
      isPresent: this.props.isPresent,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      branches: this.props.branches,
      remotes: this.props.remotes
    }, checkoutOp => _react["default"].createElement(_reviewsView["default"], _extends({
      checkoutOp: checkoutOp,
      contextLines: this.state.contextLines,
      postingToThreadID: this.state.postingToThreadID,
      summarySectionOpen: this.state.summarySectionOpen,
      commentSectionOpen: this.state.commentSectionOpen,
      threadIDsOpen: this.state.threadIDsOpen,
      scrollToThreadID: this.state.scrollToThreadID,
      moreContext: this.moreContext,
      lessContext: this.lessContext,
      openFile: this.openFile,
      openDiff: this.openDiff,
      openPR: this.openPR,
      openIssueish: this.openIssueish,
      showSummaries: this.showSummaries,
      hideSummaries: this.hideSummaries,
      showComments: this.showComments,
      hideComments: this.hideComments,
      showThreadID: this.showThreadID,
      hideThreadID: this.hideThreadID,
      resolveThread: this.resolveThread,
      unresolveThread: this.unresolveThread,
      addSingleComment: this.addSingleComment
    }, this.props)));
  }

}

exports.BareReviewsController = BareReviewsController;

_defineProperty(BareReviewsController, "propTypes", {
  // Relay results
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  viewer: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  repository: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  summaries: _propTypes["default"].array.isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  refetch: _propTypes["default"].func.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  localRepository: _propTypes["default"].object.isRequired,
  isAbsent: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  isPresent: _propTypes["default"].bool.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  multiFilePatch: _propTypes["default"].object.isRequired,
  initThreadID: _propTypes["default"].string,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // URL parameters
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportMutationErrors: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareReviewsController, {
  viewer: function () {
    const node = require("./__generated__/reviewsController_viewer.graphql");

    if (node.hash && node.hash !== "e9e4cf88f2d8a809620a0f225d502896") {
      console.error("The definition of 'reviewsController_viewer' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_viewer.graphql");
  },
  repository: function () {
    const node = require("./__generated__/reviewsController_repository.graphql");

    if (node.hash && node.hash !== "1e0016aed6db6035651ff6213eb38ff6") {
      console.error("The definition of 'reviewsController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_repository.graphql");
  },
  pullRequest: function () {
    const node = require("./__generated__/reviewsController_pullRequest.graphql");

    if (node.hash && node.hash !== "9d67f9908ab4ed776af5f1ee14f61ccb") {
      console.error("The definition of 'reviewsController_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_pullRequest.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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