"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, this.props.token);

    if (this.props.search.isNull()) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishSearchContainerQuery.graphql");

      if (node.hash && node.hash !== "fc553ba742c51417ea1a857b96038345") {
        console.error("The definition of 'issueishSearchContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishSearchContainerQuery.graphql");
    });

    const variables = {
      query: this.props.search.createQuery(),
      first: this.props.limit
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    return _react["default"].createElement(_issueishListController["default"], _extends({
      total: props.search.issueCount,
      results: props.search.nodes,
      isLoading: false
    }, this.controllerProps()));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: this.props.search.getName(),
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenMore: () => this.props.onOpenSearch(this.props.search)
    };
  }

}

exports["default"] = IssueishSearchContainer;

_defineProperty(IssueishSearchContainer, "propTypes", {
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Search model
  limit: _propTypes["default"].number,
  search: _propTypes2.SearchPropType.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  // Action methods
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenSearch: _propTypes["default"].func.isRequired
});

_defineProperty(IssueishSearchContainer, "defaultProps", {
  limit: 20
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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