Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _temp = require('temp');

var _temp2 = _interopRequireDefault(_temp);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _getIconServices = require('./get-icon-services');

var _getIconServices2 = _interopRequireDefault(_getIconServices);

var FileView = (function () {
  function FileView(parentView, indexInParentView, archivePath, entry) {
    var _this = this;

    _classCallCheck(this, FileView);

    this.disposables = new _atom.CompositeDisposable();
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.archivePath = archivePath;
    this.entry = entry;

    this.element = document.createElement('li');
    this.element.classList.add('list-item', 'entry');
    this.element.tabIndex = -1;

    this.name = document.createElement('span');
    (0, _getIconServices2['default'])().updateFileIcon(this);
    this.name.textContent = this.entry.getName();
    this.element.appendChild(this.name);

    var clickHandler = function clickHandler() {
      _this.select();
      _this.openFile();
    };
    this.element.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    }));

    this.disposables.add(atom.commands.add(this.element, {
      'core:confirm': function coreConfirm() {
        if (_this.isSelected()) {
          _this.openFile();
        }
      },

      'core:move-down': function coreMoveDown() {
        if (_this.isSelected()) {
          _this.parentView.selectFileAfterIndex(_this.indexInParentView);
        }
      },

      'core:move-up': function coreMoveUp() {
        if (_this.isSelected()) {
          _this.parentView.selectFileBeforeIndex(_this.indexInParentView);
        }
      }
    }));
  }

  _createClass(FileView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'isSelected',
    value: function isSelected() {
      return this.element.classList.contains('selected');
    }
  }, {
    key: 'logError',
    value: function logError(message, error) {
      console.error(message, error.stack != null ? error.stack : error);
    }
  }, {
    key: 'openFile',
    value: function openFile() {
      var _this2 = this;

      _lsArchive2['default'].readFile(this.archivePath, this.entry.getPath(), function (error, contents) {
        if (error != null) {
          _this2.logError('Error reading: ' + _this2.entry.getPath() + ' from ' + _this2.archivePath, error);
        } else {
          _temp2['default'].mkdir('atom-', function (error, tempDirPath) {
            if (error != null) {
              _this2.logError('Error creating temp directory: ' + tempDirPath, error);
            } else {
              (function () {
                var tempFilePath = _path2['default'].join(tempDirPath, _path2['default'].basename(_this2.archivePath), _this2.entry.getName());
                _fsPlus2['default'].writeFile(tempFilePath, contents, function (error) {
                  if (error != null) {
                    return _this2.logError('Error writing to ' + tempFilePath, error);
                  } else {
                    return atom.workspace.open(tempFilePath);
                  }
                });
              })();
            }
          });
        }
      });
    }
  }, {
    key: 'select',
    value: function select() {
      this.element.focus();

      var archiveEditorElement = this.element.closest('.archive-editor');
      // On initial tree creation, it is not possible for any entries to be selected
      // (The entries also haven't been added to the DOM yet)
      if (archiveEditorElement) {
        for (var selected of archiveEditorElement.querySelectorAll('.selected')) {
          selected.classList.remove('selected');
        }
      }
      this.element.classList.add('selected');
    }
  }]);

  return FileView;
})();

exports['default'] = FileView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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