/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultBoundedRangeModel;
import net.sf.sdedit.util.JobListener;

public class Job
extends DefaultBoundedRangeModel
implements JobListener,
Runnable {
    private LinkedList<Job> jobQueue;
    private Job currentJob;
    private List<JobListener> jobListeners = new LinkedList<JobListener>();
    private String description;
    private Exception exception;
    private Thread thread;
    private boolean interrupted;

    public Job() {
        this.setMinimum(0);
        this.setMaximum(0);
        this.setValue(0);
        this.description = "";
    }

    public Job(String description) {
        this();
        this.description = description;
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean synchronous) {
        if (synchronous) {
            this.run();
        } else {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void interrupt() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.interrupted = true;
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addJobListener(JobListener listener) {
        this.jobListeners.add(listener);
    }

    public void removeJobListener(JobListener listener) {
        this.jobListeners.remove(listener);
    }

    public Exception getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (JobListener listener : this.jobListeners) {
            listener.jobStarted(this);
        }
        if (this.jobQueue != null) {
            Iterator<JobListener> iterator = this.jobQueue;
            synchronized (iterator) {
                this.setMaximum(this.jobQueue.size() - 1);
                this.setValue(0);
                while (!this.jobQueue.isEmpty()) {
                    this.currentJob = this.jobQueue.removeFirst();
                    this.setValue(this.getValue() + 1);
                    this.currentJob.run();
                    if (Thread.currentThread().isInterrupted()) break;
                    if (this.currentJob.getException() == null) continue;
                    this.exception = this.currentJob.getException();
                    break;
                }
                this.currentJob = null;
            }
        }
        try {
            this.doJob();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            this.exception = ex;
        }
        for (JobListener listener : this.jobListeners) {
            listener.jobEnded(this);
        }
    }

    public boolean isComposite() {
        return this.jobQueue != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        if (this.jobQueue == null) {
            this.jobQueue = new LinkedList();
        }
        LinkedList<Job> linkedList = this.jobQueue;
        synchronized (linkedList) {
            this.jobQueue.addLast(job);
        }
        job.addJobListener(this);
    }

    public synchronized Job getCurrentJob() {
        return this.currentJob;
    }

    protected void doJob() throws Exception {
    }

    @Override
    public final void jobEnded(Job job) {
        for (JobListener listener : this.jobListeners) {
            listener.jobEnded(job);
        }
    }

    @Override
    public final void jobStarted(Job job) {
        for (JobListener listener : this.jobListeners) {
            listener.jobStarted(job);
        }
    }
}

