S2 = Manifold(2, 'S^2', start_index=1)
polar = S2.chart('th ph'); th, ph = polar[:]
epolar = polar.frame()
ch_basis = S2.automorphism_field()
ch_basis[1,1], ch_basis[2,2] = 1, 1/sin(th)
epolar_ON = epolar.new_frame(ch_basis, 'epolar_ON')
nab = S2.affine_connection('nab')
_ = nab.set_coef(frame=epolar_ON)
t, tmin, tmax, th0, ph0 = var('t tmin tmax th0 ph0')
v_th0, v_ph0, alpha = var('v_th0 v_ph0 alpha')
p = S2.point((th0, ph0), name='p')
Tp = S2.tangent_space(p)
v = Tp((v_th0, v_ph0), basis=epolar_ON.at(p))
c = S2.integrated_autoparallel_curve(nab, (t, tmin, tmax), v,
                                          chart=polar, name='c')
mercator = S2.chart(r'xi:(-oo,oo):\xi ze:(0,2*pi):\zeta')
xi, ze = mercator[:]
trans_map = polar.transition_map(mercator, (log(tan(th/2)), ph))
identity = S2.identity_map()
_ = identity.coord_functions(polar, mercator)
sol = c.solve(solution_key='sol-angle',
    parameters_values={tmin:0,tmax:2,th0:pi/4,ph0:0.1,v_th0:1,v_ph0:8})
interp = c.interpolate(solution_key='sol-angle',
                       interpolation_key='interp-angle')
graph2D_mercator_angle_curve = c.plot_integrated(interpolation_key='interp-angle',
                                                 chart=mercator, thickness=1)
expr_ph = ph0+v_ph0/v_th0*(ln(tan((v_th0*t+th0)/2))-ln(tan(th0/2)))
c_loxo = S2.curve({polar: [th0+v_th0*t, expr_ph]}, (t,0,2), name='c_loxo')
expr = c_loxo.expression(chart2=mercator)
graph2D_mercator_loxo = c_loxo.plot(chart=mercator,
      parameters={th0:pi/4+2*pi/180, ph0:0.1, v_th0:1, v_ph0:8},
      thickness=1, color='blue')
sphinx_plot(graph2D_mercator_angle_curve+graph2D_mercator_loxo)