/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;

public class XmlFriendlyMapper
extends MapperWrapper {
    public XmlFriendlyMapper(ClassMapper wrapped) {
        super(wrapped);
    }

    public String serializedClass(Class type) {
        String name = super.serializedClass(type);
        if ((name = name.replace('$', '-')).charAt(0) == '-') {
            name = "default" + name;
        }
        return name;
    }

    public Class realClass(String elementName) {
        if (elementName.startsWith("default-")) {
            elementName = elementName.substring(7);
        }
        elementName = elementName.replace('-', '$');
        return super.realClass(elementName);
    }

    public String serializedMember(Class type, String memberName) {
        return this.escape(super.serializedMember(type, memberName));
    }

    public String realMember(Class type, String serialized) {
        return this.unescape(super.realMember(type, serialized));
    }

    public String mapNameToXML(String javaName) {
        return this.escape(javaName);
    }

    public String mapNameFromXML(String xmlName) {
        return this.unescape(xmlName);
    }

    private String unescape(String xmlName) {
        StringBuffer result = new StringBuffer();
        int length = xmlName.length();
        for (int i = 0; i < length; ++i) {
            char c = xmlName.charAt(i);
            if (c == '_') {
                if (xmlName.charAt(i + 1) == '_') {
                    ++i;
                    result.append('_');
                    continue;
                }
                if (xmlName.length() < i + 8 || !xmlName.substring(i + 1, i + 8).equals("DOLLAR_")) continue;
                i += 7;
                result.append('$');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String escape(String javaName) {
        StringBuffer result = new StringBuffer();
        int length = javaName.length();
        for (int i = 0; i < length; ++i) {
            char c = javaName.charAt(i);
            if (c == '$') {
                result.append("_DOLLAR_");
                continue;
            }
            if (c == '_') {
                result.append("__");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

