
# -*- coding:binary -*-
require 'spec_helper'

require 'msf/core'
require 'msf/core/exploit/smb/server/share'

RSpec.describe Msf::Exploit::Remote::SMB::Server::Share do

  include_context "Msf::StringIO"

  subject(:mod) do
    mod = Msf::Exploit.new
    mod.extend described_class
    mod.send(:initialize)

    mod
  end

  let(:response_length) { 39 }
  let(:valid_response) do
    "\x00\x00\x00\x23\xff\x53\x4d\x42" +
    "\x04\x00\x00\x00\x00\x88\x01\xc8" +
    "\x00\x00\x00\x00\x00\x00\x00\x00" +
    "\x00\x00\x00\x00\x00\x00\x48\x47" +
    "\x00\x00\x44\x43\x00\x00\x00"
  end

  before(:example) do
    mod.instance_variable_set('@state', {
      msf_io => {
        :multiplex_id => 0x41424344,
        :process_id   => 0x45464748,
        :file_id      => 0xdead,
        :dir_id       => 0xbeef
      }
    })
  end

  describe "#send_close_res" do
    it "returns the number of bytes sent" do
      expect(mod.send_close_res(msf_io)).to eq(response_length)
    end

    it "sends a valid SMB_COM_CLOSE response to the client" do
      mod.send_close_res(msf_io)
      res = msf_io.read
      expect(res).to eq(valid_response)
    end
  end

end


