/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output.support;

import java.io.IOException;
import java.io.Writer;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.ProcessingInstruction;
import org.jdom.output.Format;
import org.jdom.output.support.AbstractOutputProcessor;
import org.jdom.output.support.FormatStack;
import org.jdom.output.support.XMLOutputProcessor;

public abstract class AbstractXMLOutputProcessor
extends AbstractOutputProcessor
implements XMLOutputProcessor {
    @Override
    public void process(Writer out, Format format, DocType doctype) throws IOException {
        this.printDocType(out, new FormatStack(format), doctype);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, Comment comment) throws IOException {
        this.printComment(out, new FormatStack(format), comment);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, ProcessingInstruction pi) throws IOException {
        FormatStack fstack = new FormatStack(format);
        fstack.setIgnoreTrAXEscapingPIs(true);
        this.printProcessingInstruction(out, fstack, pi);
        out.flush();
    }

    protected void write(Writer out, String str) throws IOException {
        if (str == null) {
            return;
        }
        out.write(str);
    }

    protected void printDocType(Writer out, FormatStack fstack, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        this.write(out, "<!DOCTYPE ");
        this.write(out, docType.getElementName());
        if (publicID != null) {
            this.write(out, " PUBLIC \"");
            this.write(out, publicID);
            this.write(out, "\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                this.write(out, " SYSTEM");
            }
            this.write(out, " \"");
            this.write(out, systemID);
            this.write(out, "\"");
        }
        if (internalSubset != null && !internalSubset.equals("")) {
            this.write(out, " [");
            this.write(out, fstack.getLineSeparator());
            this.write(out, docType.getInternalSubset());
            this.write(out, "]");
        }
        this.write(out, ">");
    }

    protected void printProcessingInstruction(Writer out, FormatStack fstack, ProcessingInstruction pi) throws IOException {
        String target = pi.getTarget();
        boolean piProcessed = false;
        if (!fstack.isIgnoreTrAXEscapingPIs()) {
            if (target.equals("javax.xml.transform.disable-output-escaping")) {
                fstack.setEscapeOutput(false);
                piProcessed = true;
            } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
                fstack.setEscapeOutput(true);
                piProcessed = true;
            }
        }
        if (!piProcessed) {
            String rawData = pi.getData();
            if (!"".equals(rawData)) {
                this.write(out, "<?");
                this.write(out, target);
                this.write(out, " ");
                this.write(out, rawData);
                this.write(out, "?>");
            } else {
                this.write(out, "<?");
                this.write(out, target);
                this.write(out, "?>");
            }
        }
    }

    protected void printComment(Writer out, FormatStack fstack, Comment comment) throws IOException {
        this.write(out, "<!--");
        this.write(out, comment.getText());
        this.write(out, "-->");
    }
}

