/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class JmsCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "EnableJms") || AstUtils.hasAtLeastOneAnnotation(classNode, "EnableJmsMessaging");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) throws CompilationFailedException {
        dependencies.add("spring-jms", "jms-api");
    }

    @Override
    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addStarImports(new String[]{"javax.jms", "org.springframework.jms.annotation", "org.springframework.jms.config", "org.springframework.jms.core", "org.springframework.jms.listener", "org.springframework.jms.listener.adapter"});
    }
}

