/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SocketConnector;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SocketFinder {
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final int minTimeoutForParallelConnections = 1500;
    private final Object socketFinderlock = new Object();
    private final Object parentThreadLock = new Object();
    private volatile Result result = Result.UNKNOWN;
    private int noOfSpawnedThreads = 0;
    private volatile int noOfThreadsThatNotified = 0;
    private volatile Socket selectedSocket = null;
    private volatile IOException selectedException = null;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SocketFinder");
    private final String traceID;
    private static final int ipAddressLimit = 64;
    private final SQLServerConnection conn;

    SocketFinder(String callerTraceID, SQLServerConnection sqlServerConnection) {
        this.traceID = "SocketFinder(" + callerTraceID + ")";
        this.conn = sqlServerConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket findSocket(String hostName, int portNumber, int timeoutInMilliSeconds, boolean useParallel, boolean useTnir, boolean isTnirFirstAttempt, int timeoutInMilliSecondsForFullTimeout) throws SQLServerException {
        assert (timeoutInMilliSeconds != 0) : "The driver does not allow a time out of 0";
        try {
            Object inet4Addrs;
            InetAddress[] inetAddrs = null;
            if (useParallel || useTnir) {
                inetAddrs = InetAddress.getAllByName(hostName);
                if (useTnir && inetAddrs.length > 64) {
                    useTnir = false;
                    timeoutInMilliSeconds = timeoutInMilliSecondsForFullTimeout;
                }
            }
            if (!useParallel) {
                if (useTnir && isTnirFirstAttempt) {
                    return this.getDefaultSocket(hostName, portNumber, 500);
                }
                if (!useTnir) {
                    return this.getDefaultSocket(hostName, portNumber, timeoutInMilliSeconds);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                StringBuilder loggingString = new StringBuilder(this.toString());
                loggingString.append(" Total no of InetAddresses: ");
                loggingString.append(inetAddrs.length);
                loggingString.append(". They are: ");
                for (InetAddress inetAddr : inetAddrs) {
                    loggingString.append(inetAddr.toString() + ";");
                }
                logger.finer(loggingString.toString());
            }
            if (inetAddrs.length > 64) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ipAddressLimitWithMultiSubnetFailover"));
                Object[] msgArgs = new Object[]{Integer.toString(64)};
                String errorStr = form.format(msgArgs);
                this.conn.terminate(6, errorStr);
            }
            if (Util.isIBM()) {
                timeoutInMilliSeconds = Math.max(timeoutInMilliSeconds, 1500);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + "Using Java NIO with timeout:" + timeoutInMilliSeconds);
                }
                this.findSocketUsingJavaNIO(inetAddrs, portNumber, timeoutInMilliSeconds);
            } else {
                inet4Addrs = new LinkedList();
                LinkedList<Inet6Address> inet6Addrs = new LinkedList<Inet6Address>();
                for (InetAddress inetAddr : inetAddrs) {
                    if (inetAddr instanceof Inet4Address) {
                        ((LinkedList)inet4Addrs).add((Inet4Address)inetAddr);
                        continue;
                    }
                    assert (inetAddr instanceof Inet6Address) : "Unexpected IP address " + inetAddr.toString();
                    inet6Addrs.add((Inet6Address)inetAddr);
                }
                int timeoutForEachIPAddressType = !((AbstractCollection)inet4Addrs).isEmpty() && !inet6Addrs.isEmpty() ? Math.max(timeoutInMilliSeconds / 2, 1500) : Math.max(timeoutInMilliSeconds, 1500);
                if (!((AbstractCollection)inet4Addrs).isEmpty()) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + "Using Java NIO with timeout:" + timeoutForEachIPAddressType);
                    }
                    this.findSocketUsingJavaNIO(((LinkedList)inet4Addrs).toArray(new InetAddress[0]), portNumber, timeoutForEachIPAddressType);
                }
                if (!this.result.equals((Object)Result.SUCCESS) && !inet6Addrs.isEmpty()) {
                    if (inet6Addrs.size() == 1) {
                        return this.getConnectedSocket((InetAddress)inet6Addrs.get(0), portNumber, timeoutForEachIPAddressType);
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + "Using Threading with timeout:" + timeoutForEachIPAddressType);
                    }
                    this.findSocketUsingThreading(inet6Addrs, portNumber, timeoutForEachIPAddressType);
                }
            }
            if (this.result.equals((Object)Result.UNKNOWN)) {
                inet4Addrs = this.socketFinderlock;
                synchronized (inet4Addrs) {
                    if (this.result.equals((Object)Result.UNKNOWN)) {
                        this.result = Result.FAILURE;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(this.toString() + " The parent thread updated the result to failure");
                        }
                    }
                }
            }
            if (this.result.equals((Object)Result.FAILURE)) {
                if (this.selectedException == null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " There is no selectedException. The wait calls timed out before any connect call returned or timed out.");
                    }
                    String message = SQLServerException.getErrString("R_connectionTimedOut");
                    this.selectedException = new IOException(message);
                }
                throw this.selectedException;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.close(this.selectedSocket);
            SQLServerException.ConvertConnectExceptionToSQLServerException(hostName, portNumber, this.conn, ex);
        }
        catch (IOException ex) {
            this.close(this.selectedSocket);
            SQLServerException.ConvertConnectExceptionToSQLServerException(hostName, portNumber, this.conn, ex);
        }
        assert (this.result.equals((Object)Result.SUCCESS));
        assert (this.selectedSocket != null) : "Bug in code. Selected Socket cannot be null here.";
        return this.selectedSocket;
    }

    private void findSocketUsingJavaNIO(InetAddress[] inetAddrs, int portNumber, int timeoutInMilliSeconds) throws IOException {
        assert (timeoutInMilliSeconds != 0) : "The timeout cannot be zero";
        assert (inetAddrs.length != 0) : "Number of inetAddresses should not be zero in this function";
        Selector selector = null;
        LinkedList<SocketChannel> socketChannels = new LinkedList<SocketChannel>();
        SocketChannel selectedChannel = null;
        try {
            long timeRemaining;
            selector = Selector.open();
            for (int i = 0; i < inetAddrs.length; ++i) {
                SocketChannel sChannel = SocketChannel.open();
                socketChannels.add(sChannel);
                sChannel.configureBlocking(false);
                int ops = 8;
                SelectionKey key = sChannel.register(selector, ops);
                sChannel.connect(new InetSocketAddress(inetAddrs[i], portNumber));
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer(this.toString() + " initiated connection to address: " + inetAddrs[i] + ", portNumber: " + portNumber);
            }
            long timerNow = System.currentTimeMillis();
            long timerExpire = timerNow + (long)timeoutInMilliSeconds;
            int noOfOutstandingChannels = inetAddrs.length;
            while ((timeRemaining = timerExpire - timerNow) > 0L && selectedChannel == null) {
                if (noOfOutstandingChannels <= 0) {
                    break;
                }
                int readyChannels = selector.select(timeRemaining);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " no of channels ready: " + readyChannels);
                }
                if (readyChannels != 0) {
                    Set<SelectionKey> selectedKeys = selector.selectedKeys();
                    Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
                    while (keyIterator.hasNext()) {
                        SelectionKey key = keyIterator.next();
                        SocketChannel ch = (SocketChannel)key.channel();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(this.toString() + " processing the channel :" + ch);
                        }
                        boolean connected = false;
                        try {
                            connected = ch.finishConnect();
                            assert (connected) : "finishConnect on channel:" + ch + " cannot be false";
                            selectedChannel = ch;
                            if (!logger.isLoggable(Level.FINER)) break;
                            logger.finer(this.toString() + " selected the channel :" + selectedChannel);
                            break;
                        }
                        catch (IOException ex) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer(this.toString() + " the exception: " + ex.getClass() + " with message: " + ex.getMessage() + " occured while processing the channel: " + ch);
                            }
                            this.updateSelectedException(ex, this.toString());
                            ch.close();
                            key.cancel();
                            keyIterator.remove();
                            --noOfOutstandingChannels;
                        }
                    }
                }
                timerNow = System.currentTimeMillis();
            }
        }
        catch (IOException ex) {
            this.close(selectedChannel);
            throw ex;
        }
        finally {
            this.close(selector);
            for (SocketChannel s : socketChannels) {
                if (s == selectedChannel) continue;
                this.close(s);
            }
        }
        if (selectedChannel != null) {
            SocketAddress iadd = selectedChannel.getRemoteAddress();
            this.selectedSocket = new Socket();
            this.selectedSocket.connect(iadd);
            this.result = Result.SUCCESS;
            selectedChannel.close();
        }
    }

    private Socket getDefaultSocket(String hostName, int portNumber, int timeoutInMilliSeconds) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(hostName, portNumber);
        return this.getConnectedSocket(addr, timeoutInMilliSeconds);
    }

    private Socket getConnectedSocket(InetAddress inetAddr, int portNumber, int timeoutInMilliSeconds) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(inetAddr, portNumber);
        return this.getConnectedSocket(addr, timeoutInMilliSeconds);
    }

    private Socket getConnectedSocket(InetSocketAddress addr, int timeoutInMilliSeconds) throws IOException {
        assert (timeoutInMilliSeconds != 0) : "timeout cannot be zero";
        if (addr.isUnresolved()) {
            throw new UnknownHostException();
        }
        this.selectedSocket = new Socket();
        this.selectedSocket.connect(addr, timeoutInMilliSeconds);
        return this.selectedSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSocketUsingThreading(LinkedList<Inet6Address> inetAddrs, int portNumber, int timeoutInMilliSeconds) throws IOException, InterruptedException {
        assert (timeoutInMilliSeconds != 0) : "The timeout cannot be zero";
        assert (!inetAddrs.isEmpty()) : "Number of inetAddresses should not be zero in this function";
        LinkedList<Socket> sockets = new LinkedList<Socket>();
        LinkedList<SocketConnector> socketConnectors = new LinkedList<SocketConnector>();
        try {
            this.noOfSpawnedThreads = inetAddrs.size();
            for (InetAddress inetAddress : inetAddrs) {
                Socket s = new Socket();
                sockets.add(s);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, portNumber);
                SocketConnector socketConnector = new SocketConnector(s, inetSocketAddress, timeoutInMilliSeconds, this);
                socketConnectors.add(socketConnector);
            }
            Iterator iterator = this.parentThreadLock;
            synchronized (iterator) {
                for (SocketConnector sc : socketConnectors) {
                    threadPoolExecutor.execute(sc);
                }
                long l = System.currentTimeMillis();
                long timerExpire = l + (long)timeoutInMilliSeconds;
                while (true) {
                    long timeRemaining = timerExpire - l;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " TimeRemaining:" + timeRemaining + "; Result:" + (Object)((Object)this.result) + "; Max. open thread count: " + threadPoolExecutor.getLargestPoolSize() + "; Current open thread count:" + threadPoolExecutor.getActiveCount());
                    }
                    if (timeRemaining <= 0L || !this.result.equals((Object)Result.UNKNOWN)) break;
                    this.parentThreadLock.wait(timeRemaining);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " The parent thread wokeup.");
                    }
                    l = System.currentTimeMillis();
                }
            }
        }
        finally {
            for (Socket socket : sockets) {
                if (socket == this.selectedSocket) continue;
                this.close(socket);
            }
        }
    }

    Result getResult() {
        return this.result;
    }

    void close(Selector selector) {
        block4: {
            if (null != selector) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing Selector");
                }
                try {
                    selector.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, this.toString() + ": Ignored the following error while closing Selector", e);
                }
            }
        }
    }

    void close(Socket socket) {
        block4: {
            if (null != socket) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing TCP socket:" + socket);
                }
                try {
                    socket.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, this.toString() + ": Ignored the following error while closing socket", e);
                }
            }
        }
    }

    void close(SocketChannel socketChannel) {
        block4: {
            if (null != socketChannel) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing TCP socket channel:" + socketChannel);
                }
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, this.toString() + "Ignored the following error while closing socketChannel", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateResult(Socket socket, IOException exception, String threadId) {
        if (this.result.equals((Object)Result.UNKNOWN)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("The following child thread is waiting for socketFinderLock:" + threadId);
            }
            Object object = this.socketFinderlock;
            synchronized (object) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("The following child thread acquired socketFinderLock:" + threadId);
                }
                if (this.result.equals((Object)Result.UNKNOWN)) {
                    if (exception == null && this.selectedSocket == null) {
                        this.selectedSocket = socket;
                        this.result = Result.SUCCESS;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("The socket of the following thread has been chosen:" + threadId);
                        }
                    }
                    if (exception != null) {
                        this.updateSelectedException(exception, threadId);
                    }
                }
                ++this.noOfThreadsThatNotified;
                if (this.noOfThreadsThatNotified >= this.noOfSpawnedThreads && this.result.equals((Object)Result.UNKNOWN)) {
                    this.result = Result.FAILURE;
                }
                if (!this.result.equals((Object)Result.UNKNOWN)) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("The following child thread is waiting for parentThreadLock:" + threadId);
                    }
                    Object object2 = this.parentThreadLock;
                    synchronized (object2) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("The following child thread acquired parentThreadLock:" + threadId);
                        }
                        this.parentThreadLock.notify();
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("The following child thread released parentThreadLock and notified the parent thread:" + threadId);
                    }
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("The following child thread released socketFinderLock:" + threadId);
            }
        }
    }

    public void updateSelectedException(IOException ex, String traceId) {
        boolean updatedException = false;
        if (this.selectedException == null) {
            this.selectedException = ex;
            updatedException = true;
        } else if (!(ex instanceof SocketTimeoutException) && this.selectedException instanceof SocketTimeoutException) {
            this.selectedException = ex;
            updatedException = true;
        }
        if (updatedException && logger.isLoggable(Level.FINER)) {
            logger.finer("The selected exception is updated to the following: ExceptionType:" + ex.getClass() + "; ExceptionMessage:" + ex.getMessage() + "; by the following thread:" + traceId);
        }
    }

    public String toString() {
        return this.traceID;
    }

    static enum Result {
        UNKNOWN,
        SUCCESS,
        FAILURE;

    }
}

