/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundPainter<T>
extends AbstractPainter<T> {
    private Painter[] painters = new Painter[0];
    private AffineTransform transform;
    private boolean clipPreserved = false;
    private boolean checkForDirtyChildPainters = true;
    private boolean clearLocalCacheOnly = false;

    public CompoundPainter() {
    }

    public CompoundPainter(Painter ... painters) {
        this.painters = new Painter[painters == null ? 0 : painters.length];
        if (painters != null) {
            System.arraycopy(painters, 0, this.painters, 0, painters.length);
        }
    }

    public void setPainters(Painter ... painters) {
        Painter[] old = this.getPainters();
        this.painters = new Painter[painters == null ? 0 : painters.length];
        if (painters != null) {
            System.arraycopy(painters, 0, this.painters, 0, this.painters.length);
        }
        this.setDirty(true);
        this.firePropertyChange("painters", old, this.getPainters());
    }

    public final Painter[] getPainters() {
        Painter[] results = new Painter[this.painters.length];
        System.arraycopy(this.painters, 0, results, 0, results.length);
        return results;
    }

    public boolean isClipPreserved() {
        return this.clipPreserved;
    }

    public void setClipPreserved(boolean shouldRestoreState) {
        boolean oldShouldRestoreState = this.isClipPreserved();
        this.clipPreserved = shouldRestoreState;
        this.setDirty(true);
        this.firePropertyChange("clipPreserved", oldShouldRestoreState, shouldRestoreState);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        AffineTransform old = this.getTransform();
        this.transform = transform;
        this.setDirty(true);
        this.firePropertyChange("transform", old, transform);
    }

    @Override
    protected void validate(T object) {
        boolean dirty = false;
        for (Painter p : this.painters) {
            if (!(p instanceof AbstractPainter)) continue;
            AbstractPainter ap = (AbstractPainter)p;
            ap.validate(object);
            if (!ap.isDirty()) continue;
            dirty = true;
            break;
        }
        this.clearLocalCacheOnly = true;
        this.setDirty(dirty);
        this.clearLocalCacheOnly = false;
    }

    public boolean isCheckingDirtyChildPainters() {
        return this.checkForDirtyChildPainters;
    }

    public void setCheckingDirtyChildPainters(boolean b) {
        boolean old = this.isCheckingDirtyChildPainters();
        this.checkForDirtyChildPainters = b;
        this.firePropertyChange("checkingDirtyChildPainters", old, this.isCheckingDirtyChildPainters());
    }

    @Override
    protected boolean isDirty() {
        boolean dirty = super.isDirty();
        if (dirty) {
            return true;
        }
        if (this.isCheckingDirtyChildPainters()) {
            for (Painter p : this.painters) {
                AbstractPainter ap;
                if (!(p instanceof AbstractPainter) || !(ap = (AbstractPainter)p).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clearCache() {
        if (!this.clearLocalCacheOnly) {
            for (Painter p : this.painters) {
                if (!(p instanceof AbstractPainter)) continue;
                AbstractPainter ap = (AbstractPainter)p;
                ap.clearCache();
            }
        }
        super.clearCache();
    }

    public void clearLocalCache() {
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPaint(Graphics2D g, T component, int width, int height) {
        for (Painter p : this.getPainters()) {
            Graphics2D temp = (Graphics2D)g.create();
            try {
                p.paint(temp, component, width, height);
                if (!this.isClipPreserved()) continue;
                g.setClip(temp.getClip());
            }
            finally {
                temp.dispose();
            }
        }
    }

    @Override
    protected void configureGraphics(Graphics2D g) {
        AffineTransform tx = this.getTransform();
        if (tx != null) {
            g.setTransform(tx);
        }
    }

    @Override
    protected boolean shouldUseCache() {
        return this.isCacheable() && this.painters != null && this.painters.length > 0 || super.shouldUseCache();
    }
}

