/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

class ByteBufStreamInput
extends StreamInput {
    private final ByteBuf buffer;
    private final int endIndex;

    ByteBufStreamInput(ByteBuf buffer, int length) {
        if (length > buffer.readableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer = buffer;
        int startIndex = buffer.readerIndex();
        this.endIndex = startIndex + length;
        buffer.markReaderIndex();
    }

    public BytesReference readBytesReference(int length) throws IOException {
        return super.readBytesReference(length);
    }

    public BytesRef readBytesRef(int length) throws IOException {
        return super.readBytesRef(length);
    }

    public int available() throws IOException {
        return this.endIndex - this.buffer.readerIndex();
    }

    protected void ensureCanReadBytes(int length) throws EOFException {
        int bytesAvailable = this.endIndex - this.buffer.readerIndex();
        if (bytesAvailable < length) {
            throw new EOFException("tried to read: " + length + " bytes but only " + bytesAvailable + " remaining");
        }
    }

    public void mark(int readlimit) {
        this.buffer.markReaderIndex();
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    public void reset() throws IOException {
        this.buffer.resetReaderIndex();
    }

    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)n);
    }

    public int skipBytes(int n) throws IOException {
        int nBytes = Math.min(this.available(), n);
        this.buffer.skipBytes(nBytes);
        return nBytes;
    }

    public byte readByte() throws IOException {
        try {
            return this.buffer.readByte();
        }
        catch (IndexOutOfBoundsException ex) {
            EOFException eofException = new EOFException();
            eofException.initCause(ex);
            throw eofException;
        }
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int read = this.read(b, offset, len);
        if (read < len) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void close() throws IOException {
    }
}

