/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;

public abstract class HandledTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected HandledTransportAction(String actionName, TransportService transportService, ActionFilters actionFilters, Supplier<Request> request) {
        this(actionName, true, transportService, actionFilters, request);
    }

    protected HandledTransportAction(String actionName, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader) {
        this(actionName, true, transportService, actionFilters, requestReader);
    }

    protected HandledTransportAction(String actionName, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, String executor) {
        this(actionName, true, transportService, actionFilters, requestReader, executor);
    }

    protected HandledTransportAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ActionFilters actionFilters, Supplier<Request> request) {
        super(actionName, actionFilters, transportService.getTaskManager());
        transportService.registerRequestHandler(actionName, request, "same", false, canTripCircuitBreaker, new TransportHandler());
    }

    protected HandledTransportAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader) {
        this(actionName, canTripCircuitBreaker, transportService, actionFilters, requestReader, "same");
    }

    protected HandledTransportAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, String executor) {
        super(actionName, actionFilters, transportService.getTaskManager());
        transportService.registerRequestHandler(actionName, executor, false, canTripCircuitBreaker, requestReader, new TransportHandler());
    }

    class TransportHandler
    implements TransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public final void messageReceived(Request request, TransportChannel channel, Task task) throws Exception {
            Logger logger = HandledTransportAction.this.logger;
            HandledTransportAction.this.execute(task, request, new ChannelActionListener(channel, HandledTransportAction.this.actionName, request));
        }
    }
}

