/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public abstract class AsyncFuture<T> {
    public static <T> void initializeReference(AtomicReference<AsyncFuture<T>> ref, Operation<T> operation) {
        AsyncFuture.initializeReference(ref, operation, false);
    }

    public static <T> void reinitializeReference(AtomicReference<AsyncFuture<T>> ref, Operation<T> operation) {
        AsyncFuture.initializeReference(ref, operation, true);
    }

    public static <T> void initializeTrivial(AtomicReference<AsyncFuture<T>> ref, T result) {
        ref.compareAndSet(null, new Done<T>(result));
    }

    public static <T> void initializeReference(AtomicReference<AsyncFuture<T>> ref, Operation<T> operation, boolean forceRefresh) {
        boolean updated;
        Working<T> working = new Working<T>(ref);
        if (forceRefresh) {
            ref.set(working);
            updated = true;
        } else {
            updated = ref.compareAndSet(null, working);
        }
        if (updated) {
            working.start(operation);
        }
    }

    public abstract T getSync() throws MethodIsBlockingException;

    public abstract RelayOk getAsync(Callback<? super T> var1, SyncCallback var2);

    public abstract boolean isDone();

    private static <T> RelayOk deliverResultImmediately(T result, Callback<T> callback, SyncCallback syncCallback) {
        if (callback != null) {
            callback.done(result);
        }
        return RelaySyncCallback.finish(syncCallback);
    }

    public static interface Callback<RES> {
        public void done(RES var1);
    }

    private static class Done<T>
    extends AsyncFuture<T> {
        private final T result;

        public Done(T result) {
            this.result = result;
        }

        @Override
        public T getSync() {
            return this.result;
        }

        @Override
        public RelayOk getAsync(Callback<? super T> callback, SyncCallback syncCallback) {
            return AsyncFuture.deliverResultImmediately(this.result, callback, syncCallback);
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    public static interface Operation<RES> {
        public RelayOk start(Callback<RES> var1, SyncCallback var2);
    }

    public static abstract class SyncOperation<RES> {
        private Callback<RES> callback = null;
        private SyncCallback syncCallback;
        private static final RelayOk USER_PROMISES_TO_CALL_EXECUTE = new RelayOk(){};

        public void execute() throws MethodIsBlockingException {
            if (this.callback == null) {
                return;
            }
            try {
                RES res = this.runSync();
                this.callback.done(res);
            }
            finally {
                this.syncCallback.callbackDone(null);
            }
        }

        public Operation<RES> asAsyncOperation() {
            return new Operation<RES>(){

                @Override
                public RelayOk start(Callback<RES> callback, SyncCallback syncCallback) {
                    SyncOperation.this.callback = callback;
                    SyncOperation.this.syncCallback = syncCallback;
                    return USER_PROMISES_TO_CALL_EXECUTE;
                }
            };
        }

        protected abstract RES runSync() throws MethodIsBlockingException;
    }

    private static class Working<T>
    extends AsyncFuture<T> {
        private final AtomicReference<AsyncFuture<T>> ref;
        private final List<CallbackPair<T>> callbacks = new ArrayList<CallbackPair<T>>(1);
        private boolean resultReady = false;
        private T result;
        private Exception startFailure;
        private static final RelayOk OPERATION_SHOULD_BE_RUNNING_RELAY_OK = new RelayOk(){};

        public Working(AtomicReference<AsyncFuture<T>> ref) {
            this.ref = ref;
        }

        public RelayOk start(Operation<T> operation) {
            RuntimeException e = null;
            boolean relayed = false;
            try {
                RelayOk relayOk = this.startOrFail(operation);
                relayed = true;
                RelayOk relayOk2 = relayOk;
                return relayOk2;
            }
            catch (RuntimeException ex) {
                e = ex;
                throw ex;
            }
            catch (Error er) {
                e = null;
                throw er;
            }
            finally {
                if (!relayed) {
                    this.startFailureIsReady(e);
                }
            }
        }

        private RelayOk startOrFail(Operation<T> operation) {
            Callback callback = new Callback<T>(){

                @Override
                public void done(T res) {
                    Working.this.resultIsReady(res);
                }
            };
            SyncCallback syncCallback = new SyncCallback(){

                @Override
                public void callbackDone(RuntimeException e) {
                    Working.this.resultIsReadySync(e);
                }
            };
            return operation.start(callback, syncCallback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RelayOk getAsync(Callback<? super T> callback, SyncCallback syncCallback) {
            Working working = this;
            synchronized (working) {
                if (!this.resultReady) {
                    this.callbacks.add(new CallbackPair<T>(callback, syncCallback));
                    return OPERATION_SHOULD_BE_RUNNING_RELAY_OK;
                }
            }
            return AsyncFuture.deliverResultImmediately(this.getResultOrFail(), callback, syncCallback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getSync() throws MethodIsBlockingException {
            Working working = this;
            synchronized (working) {
                if (this.resultReady) {
                    return this.getResultOrFail();
                }
            }
            class CallbackImpl
            implements Callback<T> {
                private T res;

                CallbackImpl() {
                }

                @Override
                public synchronized void done(T res) {
                    this.res = res;
                }

                synchronized T get() {
                    return this.res;
                }
            }
            CallbackImpl callback = new CallbackImpl();
            CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
            RelayOk relayOk = this.getAsync(callback, callbackSemaphore);
            callbackSemaphore.acquireDefault(relayOk);
            return callback.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Working working = this;
            synchronized (working) {
                return this.resultReady;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resultIsReady(T result) {
            Done<T> resultDone = new Done<T>(result);
            boolean updated = this.ref.compareAndSet(this, resultDone);
            if (!updated) {
                throw new IllegalStateException();
            }
            Working working = this;
            synchronized (working) {
                this.resultReady = true;
                this.result = result;
            }
            for (CallbackPair<T> pair : this.callbacks) {
                if (pair.callback == null) continue;
                pair.callback.done(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resultIsReadySync(RuntimeException e) {
            Working working = this;
            synchronized (working) {
                this.resultReady = true;
            }
            for (CallbackPair<T> pair : this.callbacks) {
                if (pair.syncCallback == null) continue;
                pair.syncCallback.callbackDone(e);
            }
        }

        private T getResultOrFail() {
            if (this.startFailure == null) {
                return this.result;
            }
            throw new RuntimeException("Failed to start operation", this.startFailure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startFailureIsReady(RuntimeException cause) {
            Working working = this;
            synchronized (working) {
                this.resultReady = true;
                this.result = null;
                this.startFailure = cause;
            }
            for (CallbackPair<T> pair : this.callbacks) {
                if (pair.syncCallback == null) continue;
                pair.syncCallback.callbackDone(cause);
            }
        }

        private static class CallbackPair<RES> {
            final Callback<? super RES> callback;
            final SyncCallback syncCallback;

            CallbackPair(Callback<? super RES> callback, SyncCallback syncCallback) {
                this.callback = callback;
                this.syncCallback = syncCallback;
            }
        }
    }
}

