/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.internal.util.HTTPServer;
import org.eclipse.oomph.ui.ButtonAnimator;
import org.eclipse.oomph.ui.InactivityDetector;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public class HelpSupport {
    private static final int INACTIVITY_SECONDS = 5;
    private static final String HELP_CONTEXT = "/help";
    private final TitleAreaDialog dialog;
    private final Set<Control> calloutControls = new HashSet<Control>();
    private final Image[] calloutImages = new Image[10];
    private final InactivityDetector inactivityDetector = new InactivityDetector(1000, 5000){

        protected void handleInactivity(Display display, boolean inactive) {
            if (inactive) {
                display.asyncExec((Runnable)HelpSupport.this.helpAnimator);
            }
            HelpSupport.this.handleInactivity(display, inactive);
        }
    };
    private HelpAnimator helpAnimator;
    private HTTPServer helpServer;
    private Browser helpBrowser;

    public HelpSupport(TitleAreaDialog dialog) {
        this.dialog = dialog;
        dialog.setHelpAvailable(true);
    }

    public final void hook(final ToolItem helpButton) {
        this.helpAnimator = new HelpAnimator(helpButton);
        Shell shell = this.dialog.getShell();
        shell.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                if (UIUtil.isBrowserAvailable()) {
                    if (HelpSupport.this.dialog.getTray() != null) {
                        HelpSupport.this.dialog.closeTray();
                        helpButton.setSelection(false);
                        return;
                    }
                    DialogTray tray = new DialogTray(){

                        protected Control createContents(Composite parent) {
                            Composite container = new Composite(parent, 0);
                            GridLayout layout = new GridLayout();
                            layout.marginHeight = 0;
                            layout.marginWidth = 0;
                            layout.verticalSpacing = 0;
                            container.setLayout((Layout)layout);
                            HelpSupport.this.helpBrowser = new Browser(container, 0);
                            GridData gridData = new GridData(4, 4, true, true);
                            gridData.widthHint = 500;
                            gridData.heightHint = 800;
                            HelpSupport.this.helpBrowser.setSize(500, 800);
                            HelpSupport.this.helpBrowser.setLayoutData((Object)gridData);
                            HelpSupport.this.helpBrowser.addDisposeListener(new DisposeListener(){

                                public void widgetDisposed(DisposeEvent e) {
                                    HelpSupport.this.helpBrowser = null;
                                    HelpSupport.this.redrawCalloutControls();
                                }
                            });
                            HelpSupport.this.updateHelp();
                            return container;
                        }
                    };
                    HelpSupport.this.dialog.openTray(tray);
                    helpButton.setSelection(true);
                } else {
                    helpButton.setSelection(false);
                    String helpPath = HelpSupport.this.getHelpPath();
                    if (helpPath != null) {
                        OS.INSTANCE.openSystemBrowser(HelpSupport.this.getHelpURL(helpPath));
                    }
                }
            }
        });
        this.detectInactivity((Control)shell);
    }

    public final boolean isHelpOpen() {
        return this.helpBrowser != null;
    }

    public final void updateHelp() {
        String helpPath = this.getHelpPath();
        if (helpPath != null) {
            this.setHelpPath(helpPath);
        }
    }

    private final String getHelpPath() {
        if (this.dialog instanceof HelpProvider) {
            HelpProvider helpProvider = (HelpProvider)this.dialog;
            String helpPath = helpProvider.getHelpPath();
            return helpPath;
        }
        return null;
    }

    public final void addHelpCallout(final Control control, final int number) {
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image image;
                if (HelpSupport.this.isHelpOpen() && (image = HelpSupport.this.getCalloutImage(number)) != null) {
                    Rectangle bounds = HelpSupport.getBounds(control);
                    e.gc.drawImage(image, bounds.width - 31, bounds.y + 10);
                }
            }
        });
        control.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (HelpSupport.this.isHelpOpen()) {
                    control.redraw();
                }
            }
        });
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            ScrollBar verticalBar = scrollable.getVerticalBar();
            ScrollBar horizontalBar = scrollable.getHorizontalBar();
            if (verticalBar != null || horizontalBar != null) {
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (HelpSupport.this.isHelpOpen()) {
                            control.redraw();
                        }
                    }
                };
                if (verticalBar != null) {
                    verticalBar.addSelectionListener((SelectionListener)listener);
                }
                if (horizontalBar != null) {
                    horizontalBar.addSelectionListener((SelectionListener)listener);
                }
            }
        }
        this.calloutControls.add(control);
    }

    public final void detectInactivity(Control control) {
        this.inactivityDetector.monitor(control);
    }

    public void dispose() {
        if (this.helpServer != null) {
            try {
                this.helpServer.stop();
            }
            catch (Exception ex) {
                UIPlugin.INSTANCE.log(ex);
            }
            this.helpServer = null;
        }
        int i = 0;
        while (i < this.calloutImages.length) {
            this.calloutImages[i] = null;
            ++i;
        }
    }

    protected void handleInactivity(Display display, boolean inactive) {
    }

    private Image getCalloutImage(int number) {
        if (this.calloutImages[number] == null) {
            this.calloutImages[number] = UIPlugin.INSTANCE.getSWTImage("callout-" + number + ".png");
        }
        return this.calloutImages[number];
    }

    private void redrawCalloutControls() {
        for (Control control : this.calloutControls) {
            if (control.isDisposed() || !control.isVisible()) continue;
            control.redraw();
        }
    }

    private synchronized String getHelpURL(String path) {
        if (this.helpServer == null) {
            try {
                this.helpServer = new HTTPServer();
                this.helpServer.addContext((HTTPServer.Context)new HTTPServer.PluginContext(HELP_CONTEXT, true));
            }
            catch (Exception ex) {
                UIPlugin.INSTANCE.log(ex, 2);
                return null;
            }
        }
        return "http://localhost:" + this.helpServer.getPort() + HELP_CONTEXT + path;
    }

    private void setHelpPath(String path) {
        if (this.helpBrowser != null) {
            String url = this.getHelpURL(path);
            if (url != null) {
                if (!url.equals(this.helpBrowser.getUrl())) {
                    Browser.clearSessions();
                    this.helpBrowser.setUrl(url);
                }
            } else {
                this.helpBrowser.setText("<h3>Help content not found.</h3>");
            }
        }
    }

    private static Rectangle getBounds(Control control) {
        Rectangle bounds = control instanceof Scrollable ? ((Scrollable)control).getClientArea() : control.getBounds();
        --bounds.width;
        --bounds.height;
        int y = HelpSupport.getHeaderHeight(control);
        bounds.y += y;
        bounds.height -= y;
        return bounds;
    }

    private static int getHeaderHeight(Control control) {
        if (control instanceof Tree) {
            return ((Tree)control).getHeaderHeight();
        }
        if (control instanceof Table) {
            return ((Table)control).getHeaderHeight();
        }
        return 0;
    }

    private final class HelpAnimator
    extends ButtonAnimator {
        public HelpAnimator(ToolItem helpButton) {
            super(UIPlugin.INSTANCE, helpButton, "help", 10);
        }

        public Shell getShell() {
            return HelpSupport.this.dialog.getShell();
        }

        protected boolean doAnimate() {
            return HelpSupport.this.inactivityDetector.isInactive() && !HelpSupport.this.isHelpOpen();
        }
    }

    public static interface HelpProvider {
        public String getHelpPath();
    }
}

