/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class RuntimeUtils {
    private static final Log log = Log.getLog(RuntimeUtils.class);
    private static final Map<IProject, IEclipsePreferences> projectPreferences = new HashMap<IProject, IEclipsePreferences>();

    public static <T> T getObjectAdapter(Object adapter, Class<T> objectType) {
        return (T)Platform.getAdapterManager().getAdapter(adapter, objectType);
    }

    public static DBRProgressMonitor makeMonitor(IProgressMonitor monitor) {
        if (monitor instanceof DBRProgressMonitor) {
            return (DBRProgressMonitor)monitor;
        }
        return new DefaultProgressMonitor(monitor);
    }

    public static IProgressMonitor getNestedMonitor(DBRProgressMonitor monitor) {
        if (monitor instanceof IProgressMonitor) {
            return (IProgressMonitor)monitor;
        }
        return monitor.getNestedMonitor();
    }

    public static File getUserHomeDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = ".";
        }
        return new File(userHome);
    }

    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).format(new Date());
    }

    public static String getCurrentTimeStamp() {
        return new SimpleDateFormat("yyyyMMddHHmm", Locale.ENGLISH).format(new Date());
    }

    public static boolean isTypeSupported(Class<?> type, Class[] supportedTypes) {
        if (type == null || ArrayUtils.isEmpty((Object[])supportedTypes)) {
            return false;
        }
        Class[] classArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class tmp = classArray[n2];
            if (tmp.isAssignableFrom(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getNativeBinaryName(String binName) {
        return GeneralUtils.isWindows() ? String.valueOf(binName) + ".exe" : binName;
    }

    public static File getNativeClientBinary(@NotNull DBPNativeClientLocation home, @Nullable String binFolder, @NotNull String binName) throws IOException {
        binName = RuntimeUtils.getNativeBinaryName(binName);
        File dumpBinary = new File(home.getPath(), binFolder == null ? binName : String.valueOf(binFolder) + "/" + binName);
        if (!dumpBinary.exists() && !(dumpBinary = new File(home.getPath(), binName)).exists()) {
            throw new IOException("Utility '" + binName + "' not found in client home '" + home.getDisplayName() + "'");
        }
        return dumpBinary;
    }

    @NotNull
    public static IStatus stripStack(@NotNull IStatus status) {
        if (status instanceof MultiStatus) {
            IStatus[] children = status.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    children[i] = RuntimeUtils.stripStack(children[i]);
                    ++i;
                }
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), children, status.getMessage(), null);
        }
        if (status instanceof Status) {
            String messagePrefix = "";
            if (status.getException() != null && CommonUtils.isEmpty((String)status.getException().getMessage())) {
                messagePrefix = String.valueOf(status.getException().getClass().getName()) + ": ";
                return new Status(status.getSeverity(), status.getPlugin(), status.getCode(), String.valueOf(messagePrefix) + status.getMessage(), null);
            }
            return status;
        }
        return status;
    }

    public static void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.warn("Sleep interrupted", e);
        }
    }

    public static String formatExecutionTime(long ms) {
        if (ms < 1000L) {
            return String.valueOf(String.valueOf(ms)) + "ms";
        }
        if (ms < 60000L) {
            return String.valueOf(String.valueOf(ms / 1000L)) + "." + String.valueOf(ms % 1000L) + "s";
        }
        long sec = ms / 1000L;
        long min = sec / 60L;
        return String.valueOf(String.valueOf(min)) + "m " + String.valueOf(sec -= min * 60L) + "s";
    }

    public static File getPlatformFile(String platformURL) throws IOException {
        URL url = new URL(platformURL);
        URL fileURL = FileLocator.toFileURL((URL)url);
        return RuntimeUtils.getLocalFileFromURL(fileURL);
    }

    public static File getLocalFileFromURL(URL fileURL) throws IOException {
        try {
            URI filePath = GeneralUtils.makeURIFromFilePath(fileURL.toString());
            return new File(filePath);
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad local file path: " + fileURL, e);
        }
    }

    public static boolean runTask(DBRRunnableWithProgress task, String taskName, long waitTime) {
        return RuntimeUtils.runTask(task, taskName, waitTime, false);
    }

    public static boolean runTask(DBRRunnableWithProgress task, String taskName, long waitTime, boolean hidden) {
        final MonitoringTask monitoringTask = new MonitoringTask(task);
        AbstractJob monitorJob = new AbstractJob(taskName, hidden){
            {
                super($anonymous0);
                if (bl) {
                    this.setSystem(true);
                    this.setUser(false);
                }
            }

            @Override
            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    monitoringTask.run(monitor);
                }
                catch (InvocationTargetException e) {
                    log.error(String.valueOf(this.getName()) + " - error", e.getTargetException());
                    return Status.OK_STATUS;
                }
                catch (InterruptedException interruptedException) {}
                return Status.OK_STATUS;
            }
        };
        monitorJob.schedule();
        long startTime = System.currentTimeMillis();
        while (!monitoringTask.finished) {
            if (waitTime > 0L && System.currentTimeMillis() - startTime > waitTime) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                log.debug("Task '" + taskName + "' was interrupted");
                break;
            }
        }
        return monitoringTask.finished;
    }

    public static boolean isPlatformMacOS() {
        return Platform.getOS().toLowerCase().contains("macos");
    }

    public static boolean isPlatformWindows() {
        return Platform.getOS().toLowerCase().contains("win32");
    }

    public static void setThreadName(String name) {
        Thread.currentThread().setName("DBeaver: " + name);
    }

    public static IEclipsePreferences getResourceHandlerPreferences(IProject project, String node) {
        IEclipsePreferences projectSettings = RuntimeUtils.getProjectPreferences(project);
        return (IEclipsePreferences)projectSettings.node(node);
    }

    public static synchronized IEclipsePreferences getProjectPreferences(IProject project) {
        IEclipsePreferences preferences = projectPreferences.get(project);
        if (preferences == null) {
            preferences = new ProjectScope(project).getNode("org.jkiss.dbeaver.project.resources");
            projectPreferences.put(project, preferences);
        }
        return preferences;
    }

    private static class MonitoringTask
    implements DBRRunnableWithProgress {
        private final DBRRunnableWithProgress task;
        private DBRProgressMonitor monitor;
        volatile boolean finished;

        private MonitoringTask(DBRRunnableWithProgress task) {
            this.task = task;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.monitor = monitor;
            try {
                this.task.run(monitor);
            }
            finally {
                monitor.done();
                this.finished = true;
            }
        }
    }
}

