/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.net;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerImpl;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SSLHandlerTrustStoreImpl
extends SSLHandlerImpl {
    public static final String PROP_SSL_CA_CERT = "ssl.ca.cert";
    public static final String PROP_SSL_CLIENT_CERT = "ssl.client.cert";
    public static final String PROP_SSL_CLIENT_KEY = "ssl.client.key";
    public static final String CERT_TYPE = "ssl";

    public static void initializeTrustStore(DBRProgressMonitor monitor, DBPDataSource dataSource, DBWHandlerConfiguration sslConfig) throws DBException, IOException {
        DBACertificateStorage securityManager = dataSource.getContainer().getPlatform().getCertificateStorage();
        String caCertProp = sslConfig.getProperties().get(PROP_SSL_CA_CERT);
        String clientCertProp = sslConfig.getProperties().get(PROP_SSL_CLIENT_CERT);
        String clientCertKeyProp = sslConfig.getProperties().get(PROP_SSL_CLIENT_KEY);
        if (!CommonUtils.isEmpty((String)caCertProp) || !CommonUtils.isEmpty((String)clientCertProp)) {
            byte[] caCertData = CommonUtils.isEmpty((String)caCertProp) ? null : IOUtils.readFileToBuffer((File)new File(caCertProp));
            byte[] clientCertData = CommonUtils.isEmpty((String)clientCertProp) ? null : IOUtils.readFileToBuffer((File)new File(clientCertProp));
            byte[] keyData = CommonUtils.isEmpty((String)clientCertKeyProp) ? null : IOUtils.readFileToBuffer((File)new File(clientCertKeyProp));
            securityManager.addCertificate(dataSource.getContainer(), CERT_TYPE, caCertData, clientCertData, keyData);
        } else {
            securityManager.deleteCertificate(dataSource.getContainer(), CERT_TYPE);
        }
    }

    public static void setGlobalTrustStore(DBPDataSource dataSource) {
        DBACertificateStorage securityManager = dataSource.getContainer().getPlatform().getCertificateStorage();
        String keyStorePath = securityManager.getKeyStorePath(dataSource.getContainer(), CERT_TYPE).getAbsolutePath();
        String keyStoreType = securityManager.getKeyStoreType(dataSource.getContainer());
        System.setProperty("javax.net.ssl.trustStore", keyStorePath);
        System.setProperty("javax.net.ssl.trustStoreType", keyStoreType);
        System.setProperty("javax.net.ssl.trustStorePassword", String.valueOf(DefaultCertificateStorage.DEFAULT_PASSWORD));
        System.setProperty("javax.net.ssl.keyStore", keyStorePath);
        System.setProperty("javax.net.ssl.keyStoreType", keyStoreType);
        System.setProperty("javax.net.ssl.keyStorePassword", String.valueOf(DefaultCertificateStorage.DEFAULT_PASSWORD));
    }

    public static SSLContext createTrustStoreSslContext(DBPDataSource dataSource) throws Exception {
        DBACertificateStorage securityManager = dataSource.getContainer().getPlatform().getCertificateStorage();
        KeyStore trustStore = securityManager.getKeyStore(dataSource.getContainer(), CERT_TYPE);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(trustStore, DefaultCertificateStorage.DEFAULT_PASSWORD);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    public static SSLSocketFactory createTrustStoreSslSocketFactory(DBPDataSource dataSource) throws Exception {
        return SSLHandlerTrustStoreImpl.createTrustStoreSslContext(dataSource).getSocketFactory();
    }
}

