/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.security;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2SchemaObject;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Grantee;
import org.jkiss.dbeaver.ext.db2.model.security.DB2GrantorGranteeType;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class DB2AuthBase
extends DB2Object<DB2Grantee>
implements DBAPrivilege {
    private DBSObject grantor;
    private DB2GrantorGranteeType grantorType;
    private DB2Schema objectSchema;
    private DBSObject object;

    public DB2AuthBase(DBRProgressMonitor monitor, DB2Grantee db2Grantee, DBSObject object, ResultSet resultSet) throws DBException {
        super(db2Grantee, String.valueOf(JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"OBJ_SCHEMA")) + "." + JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OBJ_NAME"), true);
        if (object instanceof DB2SchemaObject) {
            this.objectSchema = ((DB2SchemaObject)object).getSchema();
        } else {
            DB2DataSource db2DataSource = db2Grantee.getDataSource();
            String objectSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"OBJ_SCHEMA");
            if (objectSchemaName != null) {
                this.objectSchema = db2DataSource.getSchema(monitor, objectSchemaName);
            }
        }
        this.object = object;
        String grantorName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"GRANTOR");
        this.grantorType = (DB2GrantorGranteeType)CommonUtils.valueOf(DB2GrantorGranteeType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"GRANTORTYPE"));
        switch (this.grantorType) {
            case U: {
                this.grantor = db2Grantee.getDataSource().getUser(monitor, grantorName);
                break;
            }
            case G: {
                this.grantor = db2Grantee.getDataSource().getGroup(monitor, grantorName);
                break;
            }
        }
    }

    @Override
    @Property(hidden=true)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=1)
    public DB2Schema getObjectSchema() {
        return this.objectSchema;
    }

    @Property(viewable=true, order=2)
    public DBSObject getObject() {
        return this.object;
    }

    @Property(viewable=true, order=3)
    public DBSObject getGrantor() {
        return this.grantor;
    }

    @Property(viewable=true, order=4)
    public DB2GrantorGranteeType getGrantorType() {
        return this.grantorType;
    }
}

