/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTrigger;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTriggerManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class MySQLTriggerManager
extends SQLTriggerManager<MySQLTrigger, MySQLTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLTrigger> getObjectsCache(MySQLTrigger object) {
        return object.getCatalog().getTriggerCache();
    }

    protected MySQLTrigger createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, MySQLTable parent, Object copyFrom) {
        return new MySQLTrigger((MySQLCatalog)parent.getContainer(), parent, "NewTrigger");
    }

    protected void createOrReplaceTriggerQuery(List<DBEPersistAction> actions, MySQLTrigger trigger, boolean create) {
        MySQLCatalog curCatalog;
        if (trigger.isPersisted()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop trigger", "DROP TRIGGER IF EXISTS " + trigger.getFullyQualifiedName(DBPEvaluationContext.DDL)));
        }
        if ((curCatalog = trigger.getCatalog().getDataSource().getDefaultObject()) != trigger.getCatalog()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)trigger.getCatalog()), false));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", trigger.getBody(), true));
        if (curCatalog != null && curCatalog != trigger.getCatalog()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)curCatalog), false));
        }
    }
}

