/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.server.PortFile;
import com.sun.tools.sjavac.server.SjavacServer;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class PortFileMonitor {
    private static final int CHECK_PORTFILE_INTERVAL = 5000;
    private final Timer timer = new Timer();
    private final PortFile portFile;
    private final SjavacServer server;

    public PortFileMonitor(PortFile portFile, SjavacServer server) {
        this.portFile = portFile;
        this.server = server;
    }

    public void start() {
        final Log log = Log.get();
        TimerTask shutdownCheck = new TimerTask(){

            @Override
            public void run() {
                Log.setLogForCurrentThread(log);
                Log.debug("Checking port file status...");
                try {
                    if (!PortFileMonitor.this.portFile.exists()) {
                        PortFileMonitor.this.server.shutdown("Quitting because portfile was deleted!");
                    } else if (PortFileMonitor.this.portFile.markedForStop()) {
                        PortFileMonitor.this.server.shutdown("Quitting because a portfile.stop file was found!");
                    } else if (!PortFileMonitor.this.portFile.stillMyValues()) {
                        PortFileMonitor.this.server.shutdown("Quitting because portfile is now owned by another javac server!");
                    }
                }
                catch (IOException e) {
                    Log.error("IOException caught in PortFileMonitor.");
                    Log.debug(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Log.error(e);
                }
            }
        };
        this.timer.schedule(shutdownCheck, 0L, 5000L);
    }

    public void shutdown() {
        this.timer.cancel();
    }
}

