/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ThreadPriorityCheck", summary="Relying on the thread scheduler is discouraged; see Effective Java Item 72 (2nd edition) / 84 (3rd edition).", severity=BugPattern.SeverityLevel.WARNING)
public class ThreadPriorityCheck
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> THREAD_MATCHERS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.lang.Thread").named("yield"), Matchers.instanceMethod().onDescendantOf("java.lang.Thread").named("setPriority")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return THREAD_MATCHERS.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

