/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.natbib;

import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.natbib.Citep;
import com.dickimawbooks.texparserlib.latex.natbib.Citet;
import java.io.IOException;

public class NatbibSty
extends LaTeXSty {
    public static final int BRACKET_ROUND = 0;
    public static final int BRACKET_SQUARE = 1;
    public static final int BRACKET_CURLY = 2;
    public static final int BRACKET_ANGLE = 3;
    private int bracket = 1;
    public static final int SEP_SEMICOLON = 0;
    public static final int SEP_COMMA = 1;
    private int separator = 1;
    public static final int CITE_AUTHORYEAR = 0;
    public static final int CITE_NUMBERS = 1;
    private int citestyle = 0;
    private boolean isSuper = false;

    public NatbibSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "natbib", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new Citep(this));
        this.registerControlSequence(new Citet(this));
        if (this.citestyle == 1) {
            this.registerControlSequence(new Citep("cite", this));
        } else {
            this.registerControlSequence(new Citet("cite", this));
        }
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        if (string.equals("round")) {
            this.bracket = 0;
        } else if (string.equals("square")) {
            this.bracket = 1;
        } else if (string.equals("curly")) {
            this.bracket = 2;
        } else if (string.equals("angle")) {
            this.bracket = 3;
        } else if (string.equals("semicolon") || string.equals("colon")) {
            this.separator = 0;
        } else if (string.equals("comma")) {
            this.separator = 1;
        } else if (string.equals("authoryear")) {
            this.citestyle = 0;
        } else if (string.equals("numbers")) {
            this.citestyle = 1;
        } else if (string.equals("super")) {
            this.isSuper = true;
            this.citestyle = 1;
        }
    }

    public TeXObject getOpenBracket() {
        switch (this.bracket) {
            case 0: {
                return this.getListener().getOther(40);
            }
            case 1: {
                return this.getListener().getOther(91);
            }
            case 2: {
                return new TeXCsRef("textbraceleft");
            }
            case 3: {
                return this.getListener().getOther(10216);
            }
        }
        return new TeXObjectList();
    }

    public TeXObject getCloseBracket() {
        switch (this.bracket) {
            case 0: {
                return this.getListener().getOther(41);
            }
            case 1: {
                return this.getListener().getOther(93);
            }
            case 2: {
                return new TeXCsRef("textbraceright");
            }
            case 3: {
                return this.getListener().getOther(10217);
            }
        }
        return new TeXObjectList();
    }

    public TeXObject getSeparator() {
        switch (this.separator) {
            case 0: {
                return this.getListener().getOther(59);
            }
            case 1: {
                return this.getListener().getOther(44);
            }
        }
        return new TeXObjectList();
    }

    public int getCiteStyle() {
        return this.citestyle;
    }

    public boolean isSuper() {
        return this.isSuper;
    }
}

