/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class GoAPIGenerator
extends AbstractAPIGenerator {
    private boolean addImports = false;
    private final String HEADER = "// Zed Attack Proxy (ZAP) and its related class files.\n//\n// ZAP is an HTTP/HTTPS proxy for assessing web application security.\n//\n// Copyright 2017 the ZAP development team\n//\n// Licensed under the Apache License, Version 2.0 (the \"License\");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//   http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \"AS IS\" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n";
    private static final Map<String, String> nameMap;

    public GoAPIGenerator() {
        super("../zap-api-go/zap/");
    }

    public GoAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    @Deprecated
    public void generateGoFiles(List<ApiImplementor> implementors) throws IOException {
        this.generateAPIFiles((List)implementors);
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        String className = imp.getPrefix().substring(0, 1).toUpperCase() + imp.getPrefix().substring(1);
        String pkgName = GoAPIGenerator.safeName(GoAPIGenerator.camelCaseToLowerCaseDash(className));
        Path file = this.getDirectory().resolve(pkgName + "_generated.go");
        this.createDirAndFile(file);
        System.out.println("Generating " + file.toAbsolutePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write("// Zed Attack Proxy (ZAP) and its related class files.\n//\n// ZAP is an HTTP/HTTPS proxy for assessing web application security.\n//\n// Copyright 2017 the ZAP development team\n//\n// Licensed under the Apache License, Version 2.0 (the \"License\");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//   http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \"AS IS\" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n");
            out.write("//\n");
            out.write("// *** This file was automatically generated. ***\n");
            out.write("//\n\n");
            out.write("package zap\n\n");
            out.write("_imports_");
            out.write("type " + className + " struct {\n\tc *Client\n}\n\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generateGoElement(apiElement, className, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generateGoElement(apiElement, className, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generateGoElement(apiElement, className, imp.getPrefix(), "other", out);
            }
        }
        GoAPIGenerator.addImports(file, this.addImports);
        this.addImports = false;
    }

    private void generateGoElement(ApiElement element, String className, String component, String type, Writer out) throws IOException {
        boolean hasParams;
        boolean typeOther;
        block11: {
            typeOther = type.equals("other");
            hasParams = element.getMandatoryParamNames() != null && element.getMandatoryParamNames().size() > 0 || element.getOptionalParamNames() != null && element.getOptionalParamNames().size() > 0;
            String descTag = element.getDescriptionTag();
            if (descTag == null) {
                descTag = component + ".api." + type + "." + element.getName();
            }
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("// " + desc + "\n");
                if (this.isOptional()) {
                    out.write("//\n");
                    out.write("// This component is optional and therefore the API will only work if it is installed\n");
                }
            }
            catch (Exception e) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block11;
                out.write("// This component is optional and therefore the API will only work if it is installed\n");
            }
        }
        out.write("func (" + className.substring(0, 1).toLowerCase() + " " + className + ") ");
        out.write(GoAPIGenerator.toTitleCase(GoAPIGenerator.createMethodName(element.getName())));
        out.write("(");
        this.writeOutArgs(element.getMandatoryParamNames(), out, hasParams);
        if (element.getMandatoryParamNames() != null && element.getMandatoryParamNames().size() > 0 && element.getOptionalParamNames() != null && element.getOptionalParamNames().size() > 0) {
            out.write(", ");
        }
        this.writeOutArgs(element.getOptionalParamNames(), out, hasParams);
        out.write(")");
        if (typeOther) {
            out.write(" ([]byte, error) ");
        } else {
            out.write(" (map[string]interface{}, error) ");
        }
        out.write("{\n");
        if (hasParams) {
            out.write("\tm := map[string]string{");
            this.writeOutRequestParams(element.getMandatoryParamNames(), out);
            this.writeOutRequestParams(element.getOptionalParamNames(), out);
            out.write("\n\t}\n");
        }
        String method = className.substring(0, 1).toLowerCase() + ".c.Request";
        if (typeOther) {
            method = method + "Other";
        }
        out.write("\treturn " + method + "(\"" + component + "/" + type + "/" + element.getName() + "/\"");
        if (hasParams) {
            out.write(", m");
        } else {
            out.write(", nil");
        }
        out.write(")\n");
        out.write("}\n\n");
    }

    private void createDirAndFile(Path path) throws IOException {
        File file = new File(path.toAbsolutePath().toString());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    private void writeOutArgs(List<String> elements, Writer out, boolean hasParams) throws IOException {
        if (elements != null && elements.size() > 0) {
            ArrayList<String> args = new ArrayList<String>();
            for (String param : elements) {
                if (param.toLowerCase().equals("boolean")) {
                    args.add("boolean bool");
                    continue;
                }
                if (param.toLowerCase().equals("integer")) {
                    args.add("i int");
                    continue;
                }
                if (param.toLowerCase().equals("string")) {
                    args.add("str string");
                    continue;
                }
                if (param.toLowerCase().equals("type")) {
                    args.add("t string");
                    continue;
                }
                args.add(param.toLowerCase() + " string");
            }
            out.write(StringUtils.join(args, (String)", "));
        }
    }

    private void writeOutRequestParams(List<String> elements, Writer out) throws IOException {
        if (elements != null && elements.size() > 0) {
            for (String param : elements) {
                out.write("\n\t\t\"" + param + "\": ");
                if (param.toLowerCase().equals("boolean")) {
                    this.addImports = true;
                    out.write("strconv.FormatBool(boolean)");
                } else if (param.toLowerCase().equals("integer")) {
                    this.addImports = true;
                    out.write("strconv.Itoa(i)");
                } else if (param.toLowerCase().equals("string")) {
                    out.write("str");
                } else if (param.toLowerCase().equals("type")) {
                    out.write("t");
                } else {
                    out.write(param.toLowerCase());
                }
                out.write(",");
            }
        }
    }

    private static String safeName(String name) {
        if (nameMap.containsKey(name)) {
            return nameMap.get(name);
        }
        return name;
    }

    private static String createMethodName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return GoAPIGenerator.removeAllFullStopCharacters(name);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    public static String camelCaseToLowerCaseDash(String s) {
        return GoAPIGenerator.safeName(s).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "-").toLowerCase();
    }

    private static String toTitleCase(String input) {
        StringBuilder titleCase = new StringBuilder();
        boolean nextTitleCase = true;
        for (char c : input.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                nextTitleCase = true;
            } else if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }

    private static void addImports(Path file, boolean addImports) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(file), charset);
        content = addImports ? content.replaceAll("_imports_", "import \"strconv\"\n\n") : content.replaceAll("_imports_", "");
        Files.write(file, content.getBytes(charset), new OpenOption[0]);
    }

    public static void main(String[] args) throws Exception {
        GoAPIGenerator gapi = new GoAPIGenerator();
        gapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

