/*
 * Decompiled with CFR 0.152.
 */
package scala.reflect.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.Directory;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u0001\u0003\u0001\u0019A!\u0001\u0004)mC&tg*[8GS2,'BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u00059!/\u001a4mK\u000e$(\"A\u0004\u0002\u000bM\u001c\u0017\r\\1\u0014\u0005\u0001I\u0001C\u0001\u0006\f\u001b\u0005\u0011\u0011B\u0001\u0007\u0003\u00051\t%m\u001d;sC\u000e$h)\u001b7f\u0011!q\u0001A!A!\u0002\u0013\u0001\u0012a\u00028j_B\u000bG\u000f[\u0002\u0001!\t\t\u0002$D\u0001\u0013\u0015\t\u0019B#\u0001\u0003gS2,'BA\u000b\u0017\u0003\rq\u0017n\u001c\u0006\u0002/\u0005!!.\u0019<b\u0013\tI\"C\u0001\u0003QCRD\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e=A\u0011!\u0002\u0001\u0005\u0006\u001di\u0001\r\u0001\u0005\u0005\u0006'\u0001!\t\u0005I\u000b\u0002CA\u0011!\u0005J\u0007\u0002G)\u00111AF\u0005\u0003K\r\u0012AAR5mK\"Aq\u0005\u0001EC\u0002\u0013\u0005\u0003&A\u0007dC:|g.[2bYB\u000bG\u000f[\u000b\u0002SA\u0011!&\r\b\u0003W=\u0002\"\u0001\f\u0004\u000e\u00035R!AL\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0001d!\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019\u0007\u0011\u0015)\u0004\u0001\"\u00117\u0003A)h\u000eZ3sYfLgnZ*pkJ\u001cW-F\u00018!\rA\u0014(H\u0007\u0002\r%\u0011!H\u0002\u0002\u0005'>lW\rC\u0004=\u0001\t\u0007I\u0011B\u001f\u0002\u000b\u0019\u0004\u0018\r\u001e5\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\f\u0002\t1\fgnZ\u0005\u0003e\u0001Ca\u0001\u0012\u0001!\u0002\u0013q\u0014A\u00024qCRD\u0007\u0005C\u0003G\u0001\u0011\u0005Q(\u0001\u0003oC6,\u0007\"\u0002%\u0001\t\u0003i\u0014\u0001\u00029bi\"DQA\u0013\u0001\u0005\u0002-\u000b\u0001\"\u00192t_2,H/Z\u000b\u0002;!)Q\n\u0001C!\u001d\u0006I1m\u001c8uC&tWM]\u000b\u0002\u0013!)\u0001\u000b\u0001C!#\u0006)\u0011N\u001c9viV\t!\u000b\u0005\u0002#'&\u0011Ak\t\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003W\u0001\u0011\u0005s+\u0001\u0004pkR\u0004X\u000f^\u000b\u00021B\u0011!%W\u0005\u00035\u000e\u0012AbT;uaV$8\u000b\u001e:fC6DQ\u0001\u0018\u0001\u0005Bu\u000b!b]5{K>\u0003H/[8o+\u0005q\u0006c\u0001\u001d:?B\u0011\u0001\bY\u0005\u0003C\u001a\u00111!\u00138u\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003!A\u0017m\u001d5D_\u0012,G#A0\t\u000b\u0019\u0004A\u0011I4\u0002\r\u0015\fX/\u00197t)\tA7\u000e\u0005\u00029S&\u0011!N\u0002\u0002\b\u0005>|G.Z1o\u0011\u0015aW\r1\u0001n\u0003\u0011!\b.\u0019;\u0011\u0005ar\u0017BA8\u0007\u0005\r\te.\u001f\u0005\u0006c\u0002!\tA]\u0001\fSN$\u0015N]3di>\u0014\u00180F\u0001i\u0011\u0015!\b\u0001\"\u0001v\u00031a\u0017m\u001d;N_\u0012Lg-[3e+\u00051\bC\u0001\u001dx\u0013\tAhA\u0001\u0003M_:<\u0007\"\u0002>\u0001\t\u0003Y\u0018\u0001C5uKJ\fGo\u001c:\u0016\u0003q\u0004B!`A\u0001\u00139\u0011\u0001H`\u0005\u0003\u007f\u001a\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0004\u0005\u0015!\u0001C%uKJ\fGo\u001c:\u000b\u0005}4\u0001bBA\u0005\u0001\u0011\u0005\u00111B\u0001\u000bY>|7.\u001e9OC6,G#B\u0005\u0002\u000e\u0005=\u0001B\u0002$\u0002\b\u0001\u0007\u0011\u0006C\u0004\u0002\u0012\u0005\u001d\u0001\u0019\u00015\u0002\u0013\u0011L'/Z2u_JL\bbBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0007GJ,\u0017\r^3\u0015\u0005\u0005e\u0001c\u0001\u001d\u0002\u001c%\u0019\u0011Q\u0004\u0004\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003C\u0001A\u0011AA\f\u0003\u0019!W\r\\3uK\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0012a\u00057p_.,\bOT1nKVs7\r[3dW\u0016$G#B\u0005\u0002*\u0005-\u0002B\u0002$\u0002$\u0001\u0007\u0011\u0006C\u0004\u0002\u0012\u0005\r\u0002\u0019\u00015")
public class PlainNioFile
extends AbstractFile {
    private String canonicalPath;
    private final Path nioPath;
    private final String fpath;
    private volatile boolean bitmap$0;

    @Override
    public File file() {
        File file;
        try {
            file = this.nioPath.toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            file = null;
        }
        return file;
    }

    private String canonicalPath$lzycompute() {
        PlainNioFile plainNioFile = this;
        synchronized (plainNioFile) {
            if (!this.bitmap$0) {
                this.canonicalPath = super.canonicalPath();
                this.bitmap$0 = true;
            }
        }
        return this.canonicalPath;
    }

    @Override
    public String canonicalPath() {
        return !this.bitmap$0 ? this.canonicalPath$lzycompute() : this.canonicalPath;
    }

    public Some<PlainNioFile> underlyingSource() {
        return new Some((Object)this);
    }

    private String fpath() {
        return this.fpath;
    }

    @Override
    public String name() {
        return ((Object)this.nioPath.getFileName()).toString();
    }

    @Override
    public String path() {
        return ((Object)this.nioPath).toString();
    }

    @Override
    public PlainNioFile absolute() {
        return new PlainNioFile(this.nioPath.toAbsolutePath());
    }

    @Override
    public AbstractFile container() {
        return new PlainNioFile(this.nioPath.getParent());
    }

    @Override
    public InputStream input() {
        return Files.newInputStream(this.nioPath, new OpenOption[0]);
    }

    @Override
    public OutputStream output() {
        return Files.newOutputStream(this.nioPath, new OpenOption[0]);
    }

    public Some<Object> sizeOption() {
        return new Some((Object)BoxesRunTime.boxToInteger((int)((int)Files.size(this.nioPath))));
    }

    public int hashCode() {
        return this.fpath().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof PlainNioFile) {
            PlainNioFile plainNioFile = (PlainNioFile)object;
            String string = this.fpath();
            String string2 = plainNioFile.fpath();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.nioPath, new LinkOption[0]);
    }

    @Override
    public long lastModified() {
        return Files.getLastModifiedTime(this.nioPath, new LinkOption[0]).toMillis();
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        Iterator iterator;
        try {
            java.util.Iterator<Path> it = Files.newDirectoryStream(this.nioPath).iterator();
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(it).asScala()).map((Function1 & java.io.Serializable & Serializable)x$3 -> new PlainNioFile((Path)x$3));
        }
        catch (NotDirectoryException notDirectoryException) {
            iterator = package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        Path child = this.nioPath.resolve(name);
        return Files.isDirectory(child, new LinkOption[0]) && directory || Files.isRegularFile(child, new LinkOption[0]) && !directory ? new PlainNioFile(child) : null;
    }

    @Override
    public void create() {
        block0: {
            if (this.exists()) break block0;
            Files.createFile(this.nioPath, new FileAttribute[0]);
        }
    }

    @Override
    public void delete() {
        block1: {
            block0: {
                if (!Files.isRegularFile(this.nioPath, new LinkOption[0])) break block0;
                Files.deleteIfExists(this.nioPath);
                break block1;
            }
            if (!Files.isDirectory(this.nioPath, new LinkOption[0])) break block1;
            new Directory(this.nioPath.toFile()).deleteRecursively();
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        return new PlainNioFile(this.nioPath.resolve(name));
    }

    public PlainNioFile(Path nioPath) {
        this.nioPath = nioPath;
        Predef$.MODULE$.assert(nioPath != null);
        this.fpath = ((Object)nioPath.toAbsolutePath()).toString();
    }
}

