/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleId
implements Comparable {
    static final String ENCODE_SEPARATOR = ":#@#:";
    private static final Map CACHE = new WeakHashMap();
    private String organisation;
    private String name;
    private int hash;
    private Map attributes = new HashMap();
    public static final Pattern MID_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)");

    public static ModuleId newInstance(String string, String string2) {
        return ModuleId.intern(new ModuleId(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleId intern(ModuleId moduleId) {
        ModuleId moduleId2 = null;
        Map map = CACHE;
        synchronized (map) {
            WeakReference weakReference = (WeakReference)CACHE.get(moduleId);
            if (weakReference != null) {
                moduleId2 = (ModuleId)weakReference.get();
            }
            if (moduleId2 == null) {
                moduleId2 = moduleId;
                CACHE.put(moduleId2, new WeakReference<ModuleId>(moduleId2));
            }
        }
        return moduleId2;
    }

    public ModuleId(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("null name not allowed");
        }
        this.organisation = string;
        this.name = string2;
        this.attributes.put("organisation", string);
        this.attributes.put("module", string2);
    }

    public String getName() {
        return this.name;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModuleId)) {
            return false;
        }
        ModuleId moduleId = (ModuleId)object;
        if (moduleId.organisation == null) {
            return this.organisation == null && moduleId.name.equals(this.name);
        }
        return moduleId.organisation.equals(this.organisation) && moduleId.name.equals(this.name);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.organisation == null ? 0 : this.organisation.hashCode());
            this.hash = this.hash * 13 + this.name.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.organisation + "#" + this.name;
    }

    public int compareTo(Object object) {
        ModuleId moduleId = (ModuleId)object;
        int n = this.organisation.compareTo(moduleId.organisation);
        if (n == 0) {
            n = this.name.compareTo(moduleId.name);
        }
        return n;
    }

    public String encodeToString() {
        return this.getOrganisation() + ENCODE_SEPARATOR + this.getName();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public static ModuleId decode(String string) {
        String[] stringArray = string.split(ENCODE_SEPARATOR);
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("badly encoded module id: '" + string + "'");
        }
        return new ModuleId(stringArray[0], stringArray[1]);
    }

    public static ModuleId parse(String string) {
        Matcher matcher = MID_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("module text representation do not match expected pattern. given mid='" + string + "' expected form=" + MID_PATTERN.pattern());
        }
        return ModuleId.newInstance(matcher.group(1), matcher.group(2));
    }
}

