/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.formimpl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import net.sf.launch4j.binding.Bindings;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.form.JreForm;
import net.sf.launch4j.formimpl.AbstractAcceptListener;
import net.sf.launch4j.formimpl.Messages;

public class JreFormImpl
extends JreForm {
    public JreFormImpl(Bindings bindings, JFileChooser fc) {
        this._jdkPreferenceCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("jdkPreference.jre.only"), Messages.getString("jdkPreference.prefer.jre"), Messages.getString("jdkPreference.prefer.jdk"), Messages.getString("jdkPreference.jdk.only")}));
        this._runtimeBitsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("runtimeBits.64"), Messages.getString("runtimeBits.64And32"), Messages.getString("runtimeBits.32And64"), Messages.getString("runtimeBits.32")}));
        bindings.add("jre.path", this._jrePathField).add("jre.bundledJre64Bit", this._bundledJre64BitCheck).add("jre.bundledJreAsFallback", this._bundledJreAsFallbackCheck).add("jre.minVersion", this._jreMinField).add("jre.maxVersion", this._jreMaxField).add("jre.jdkPreferenceIndex", this._jdkPreferenceCombo, Jre.DEFAULT_JDK_PREFERENCE_INDEX).add("jre.runtimeBitsIndex", this._runtimeBitsCombo, Jre.DEFAULT_JDK_PREFERENCE_INDEX).add("jre.initialHeapSize", this._initialHeapSizeField).add("jre.initialHeapPercent", this._initialHeapPercentField).add("jre.maxHeapSize", this._maxHeapSizeField).add("jre.maxHeapPercent", this._maxHeapPercentField).add("jre.options", this._jvmOptionsTextArea);
        this._varCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"EXEDIR", "EXEFILE", "PWD", "OLDPWD", "JREHOMEDIR", "HKEY_CLASSES_ROOT", "HKEY_CURRENT_USER", "HKEY_LOCAL_MACHINE", "HKEY_USERS", "HKEY_CURRENT_CONFIG"}));
        this._varCombo.addActionListener(new VarComboActionListener());
        this._varCombo.setSelectedIndex(0);
        this._propertyButton.addActionListener(new PropertyActionListener());
        this._optionButton.addActionListener(new OptionActionListener());
        this._envPropertyButton.addActionListener(new EnvPropertyActionListener(this._envVarField));
        this._envOptionButton.addActionListener(new EnvOptionActionListener(this._envVarField));
    }

    private class EnvOptionActionListener
    extends EnvActionListener {
        public EnvOptionActionListener(JTextField f) {
            super(f, false);
        }

        @Override
        protected void add(String var, int pos) {
            JreFormImpl.this._jvmOptionsTextArea.insert("%" + var + "%\n", pos);
        }
    }

    private class EnvPropertyActionListener
    extends EnvActionListener {
        public EnvPropertyActionListener(JTextField f) {
            super(f, true);
        }

        @Override
        protected void add(String var, int pos) {
            String prop = var.replaceAll(" ", ".").replaceAll("_", ".").toLowerCase();
            JreFormImpl.this._jvmOptionsTextArea.insert("-Denv." + prop + "=\"%" + var + "%\"\n", pos);
        }
    }

    private abstract class EnvActionListener
    extends AbstractAcceptListener {
        public EnvActionListener(JTextField f, boolean listen) {
            super(f, listen);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos = JreFormImpl.this._jvmOptionsTextArea.getCaretPosition();
            String var = this.getText().replaceAll("\"", "").replaceAll("%", "");
            if (Validator.isEmpty(var)) {
                this.signalViolation(Messages.getString("specifyVar"));
                return;
            }
            this.add(var, pos);
            this.clear();
        }

        protected abstract void add(String var1, int var2);
    }

    private class OptionActionListener
    implements ActionListener {
        private OptionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos = JreFormImpl.this._jvmOptionsTextArea.getCaretPosition();
            String var = (String)JreFormImpl.this._varCombo.getSelectedItem();
            if (var.startsWith("HKEY_")) {
                JreFormImpl.this._jvmOptionsTextArea.insert("%" + var + "\\...%\n", pos);
            } else {
                JreFormImpl.this._jvmOptionsTextArea.insert("%" + var + "%\n", pos);
            }
        }
    }

    private class PropertyActionListener
    implements ActionListener {
        private PropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos = JreFormImpl.this._jvmOptionsTextArea.getCaretPosition();
            String var = (String)JreFormImpl.this._varCombo.getSelectedItem();
            if (var.startsWith("HKEY_")) {
                JreFormImpl.this._jvmOptionsTextArea.insert("-Dreg.key=\"%" + var + "\\...%\"\n", pos);
            } else {
                JreFormImpl.this._jvmOptionsTextArea.insert("-Dlaunch4j." + var.toLowerCase() + "=\"%" + var + "%\"\n", pos);
            }
        }
    }

    private class VarComboActionListener
    implements ActionListener {
        private VarComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JreFormImpl.this._optionButton.setEnabled(((String)JreFormImpl.this._varCombo.getSelectedItem()).startsWith("HKEY_"));
        }
    }
}

