/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.processor.PrefixProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NumberPrefixProcessor
implements PrefixProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(NumberPrefixProcessor.class);
    private final String findRegexp;

    NumberPrefixProcessor(String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            throw new IllegalArgumentException("Prefix cannot be blank");
        }
        this.findRegexp = String.format("\\[%s(#*)(-?[0-9]*)\\]", prefix);
    }

    protected String findAndReplace(String inputString, Integer num) {
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile(this.findRegexp).matcher(inputString);
        while (m.find()) {
            String replacement = this.getReplacement(m.group(1), m.group(2), num);
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String getReplacement(String numberPatter, String startingNumber, Integer num) {
        String replacement = "";
        Integer number = this.getReplacementNumber(startingNumber, num);
        replacement = StringUtils.isNotBlank((CharSequence)numberPatter) ? this.formatter(numberPatter).format(number) : number.toString();
        return replacement;
    }

    private Integer getReplacementNumber(String startingNumber, Integer num) {
        if (StringUtils.isNotBlank((CharSequence)startingNumber)) {
            return num + Integer.valueOf(startingNumber);
        }
        return num;
    }

    private DecimalFormat formatter(String numberPattern) {
        DecimalFormat retVal = new DecimalFormat();
        try {
            if (StringUtils.isNotBlank((CharSequence)numberPattern)) {
                retVal.applyPattern(numberPattern.replaceAll("#", "0"));
                return retVal;
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.error(String.format("Error applying pattern %s", numberPattern), (Throwable)iae);
        }
        retVal.applyPattern("00000");
        return retVal;
    }
}

