/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.ConvertToDiamondBulkHintPanel;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ConvertToDiamondBulkHint {
    public static final String ID = "Javac_canUseDiamond";
    public static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.warn.diamond.redundant.args"));
    private static final Map<String, Collection<String>> key2Pattern = new LinkedHashMap<String, Collection<String>>();
    static final String KEY = "enabledVariants";
    static final String ALL = "argument,assignment,initializer,other,return";

    public static boolean isHintEnabled() {
        return true;
    }

    public static ErrorDescription compute(HintContext ctx) {
        TreePath parentPath = ctx.getPath().getParentPath();
        boolean isVarInit = MatcherUtilities.matches((HintContext)ctx, (TreePath)parentPath, (String)"$mods$ $type $name = $init;");
        if (isVarInit && ctx.getInfo().getTreeUtilities().isVarType(parentPath)) {
            return null;
        }
        if (((Collection)ctx.getMultiVariables().get("$tparams$")).isEmpty()) {
            return null;
        }
        TreePath clazz = (TreePath)ctx.getVariables().get("$clazz");
        long start = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(clazz.getCompilationUnit(), clazz.getLeaf());
        ctx.getVariables().put("$init", ctx.getPath());
        block0: for (Diagnostic d : ctx.getInfo().getDiagnostics()) {
            if (start != d.getStartPosition() || !CODES.contains(d.getCode())) continue;
            for (Map.Entry<String, Collection<String>> e : key2Pattern.entrySet()) {
                for (String p : e.getValue()) {
                    if (p != null && !MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)p)) continue;
                    boolean enabled = ConvertToDiamondBulkHint.isEnabled(ctx, e.getKey());
                    if (!enabled) continue block0;
                }
            }
            if (ConvertToDiamondBulkHint.checkAmbiguousOverload(ctx.getInfo(), ctx.getPath())) {
                return null;
            }
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)clazz.getParentPath(), (String)d.getMessage(null), (Fix[])new Fix[]{new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix()});
        }
        return null;
    }

    private static boolean checkAmbiguousOverload(CompilationInfo info, TreePath newPath) {
        if (info.getSourceVersion().compareTo(SourceVersion.RELEASE_8) > 0) {
            return false;
        }
        Element el = info.getTrees().getElement(newPath);
        if (el == null || el.getKind() != ElementKind.CONSTRUCTOR) {
            return false;
        }
        ExecutableElement ctor = (ExecutableElement)el;
        DeclaredType resolvedType = (DeclaredType)info.getTrees().getTypeMirror(newPath);
        ExecutableType ctorType = (ExecutableType)info.getTypes().asMemberOf(resolvedType, el);
        for (ExecutableElement ee : ElementFilter.constructorsIn(el.getEnclosingElement().getEnclosedElements())) {
            TypeMirror t;
            if (ee == el || ee.getParameters().size() != ctor.getParameters().size() || !Utilities.isValidType(t = info.getTypes().asMemberOf(resolvedType, ee)) || t.getKind() != TypeKind.EXECUTABLE) continue;
            ExecutableType et = (ExecutableType)t;
            for (int i = 0; i < ee.getParameters().size(); ++i) {
                TypeMirror earg = et.getParameterTypes().get(i);
                TypeMirror carg = ctorType.getParameterTypes().get(i);
                if (earg.getKind().isPrimitive() || carg.getKind().isPrimitive()) continue;
                TypeMirror erasedC = info.getTypes().erasure(carg);
                TypeMirror erasedE = info.getTypes().erasure(earg);
                if (!info.getTypes().isAssignable(erasedC, earg) || info.getTypes().isSameType(erasedC, erasedE)) continue;
                return true;
            }
        }
        return false;
    }

    static String getConfiguration(Preferences p) {
        return p.get(KEY, ALL);
    }

    static void putConfiguration(Preferences p, String configuration) {
        p.put(KEY, configuration);
    }

    private static boolean isEnabled(HintContext ctx, String key) {
        return ConvertToDiamondBulkHint.isEnabled(ctx.getPreferences(), key);
    }

    static boolean isEnabled(Preferences p, String key) {
        return ("," + ConvertToDiamondBulkHint.getConfiguration(p) + ",").contains("," + key + ",");
    }

    static {
        key2Pattern.put("initializer", Arrays.asList("$mods$ $type $name = $init;"));
        key2Pattern.put("assignment", Arrays.asList("$var = $init"));
        key2Pattern.put("return", Arrays.asList("return $init;"));
        key2Pattern.put("argument", Arrays.asList("$site.<$T$>$name($p$, $init, $s$)", "$name($p$, $init, $s$)", "new $type<$T$>($p$, $init, $s$)", "new $type($p$, $init, $s$)"));
        key2Pattern.put("other", Arrays.asList(new String[]{null}));
    }

    public static final class CustomizerProviderImpl
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            return new ConvertToDiamondBulkHintPanel(prefs);
        }
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
        }

        public String getText() {
            return NbBundle.getMessage(ConvertToDiamondBulkHint.class, (String)"FIX_ConvertToDiamond");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            if (tp.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                return;
            }
            NewClassTree nct = (NewClassTree)tp.getLeaf();
            if (nct.getIdentifier().getKind() != Tree.Kind.PARAMETERIZED_TYPE) {
                return;
            }
            TreeMaker make = copy.getTreeMaker();
            ParameterizedTypeTree ptt = (ParameterizedTypeTree)((Object)nct.getIdentifier());
            ParameterizedTypeTree nue = make.ParameterizedType(ptt.getType(), Collections.emptyList());
            copy.rewrite((Tree)ptt, (Tree)nue);
        }
    }
}

