/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.nbjavac.parsing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.lib.nbjavac.services.NBTreeMaker;

class FindAnonymousVisitor
extends ErrorAwareTreeScanner<Void, Void> {
    int firstInner = -1;
    int noInner;
    boolean hasLocalClass;
    final Set<Tree> docOwners = new HashSet<Tree>();
    private Mode mode = Mode.COLLECT;

    FindAnonymousVisitor() {
    }

    public final void reset() {
        this.firstInner = -1;
        this.noInner = 0;
        this.hasLocalClass = false;
        this.mode = Mode.CHECK;
    }

    public Void visitClass(ClassTree node, Void p) {
        if (this.firstInner == -1) {
            this.firstInner = ((NBTreeMaker.IndexedClassDecl)node).index;
        }
        if (node.getSimpleName().length() != 0) {
            this.hasLocalClass = true;
        }
        ++this.noInner;
        this.handleDoc(node);
        return (Void)super.visitClass(node, (Object)p);
    }

    public Void visitMethod(MethodTree node, Void p) {
        this.handleDoc(node);
        return (Void)super.visitMethod(node, (Object)p);
    }

    public Void visitVariable(VariableTree node, Void p) {
        this.handleDoc(node);
        return (Void)super.visitVariable(node, (Object)p);
    }

    private void handleDoc(Tree tree) {
        if (this.mode == Mode.COLLECT) {
            this.docOwners.add(tree);
        }
    }

    private static enum Mode {
        COLLECT,
        CHECK;

    }
}

