/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.openide.util.NbPreferences;

class CollapsibleSplitPane
extends JSplitPane {
    private static final String PREF_COLLAPSED = "org.netbeans.modules.profiler.heapwalk.ui.CollapsibleSplitPane.collapsed";
    private static final String PREF_LOCATION = "org.netbeans.modules.profiler.heapwalk.ui.CollapsibleSplitPane.location";
    private int savedDividerLocation;

    CollapsibleSplitPane(Component top, Component bottom) {
        super(0, top, bottom);
        CustomSplitterUI cui = new CustomSplitterUI();
        super.setUI(cui);
        this.setResizeWeight(1.0);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.savedDividerLocation = NbPreferences.forModule(CollapsibleSplitPane.class).getInt(PREF_LOCATION, this.getPreferredSize().height - 150);
        cui.setCollapsed(NbPreferences.forModule(CollapsibleSplitPane.class).getBoolean(PREF_COLLAPSED, false));
    }

    void setCollapsed(boolean collapsed) {
        this.getBottomComponent().setVisible(!collapsed);
        if (!collapsed) {
            this.setDividerLocation(this.savedDividerLocation);
        }
        NbPreferences.forModule(CollapsibleSplitPane.class).putBoolean(PREF_COLLAPSED, collapsed);
    }

    @Override
    public void setDividerLocation(int location) {
        if (!((CustomSplitterUI)this.getUI()).isCollapsed()) {
            this.savedDividerLocation = location;
            NbPreferences.forModule(CollapsibleSplitPane.class).putInt(PREF_LOCATION, this.savedDividerLocation);
        }
        super.setDividerLocation(location);
    }

    @Override
    public void setUI(SplitPaneUI ui) {
    }

    @Override
    public void updateUI() {
    }

    private static class CustomSplitterDivider
    extends BasicSplitPaneDivider {
        private boolean isCollapsed;

        public CustomSplitterDivider(CustomSplitterUI ui) {
            super(ui);
            this.setLayout(new BorderLayout());
            this.updateCursor();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.setCollapsed(!isCollapsed);
                }
            });
        }

        @Override
        public int getDividerSize() {
            return 6;
        }

        @Override
        public Border getBorder() {
            return null;
        }

        @Override
        public CustomSplitterUI getBasicSplitPaneUI() {
            return (CustomSplitterUI)super.getBasicSplitPaneUI();
        }

        @Override
        protected void setMouseOver(boolean mouseOver) {
            super.setMouseOver(mouseOver);
            this.repaint();
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        void setCollapsed(boolean collapsed) {
            this.isCollapsed = collapsed;
            this.updateCursor();
            this.getBasicSplitPaneUI().getSplitPane().setCollapsed(this.isCollapsed);
            this.repaint();
        }

        boolean isCollapsed() {
            return this.isCollapsed;
        }

        private void updateCursor() {
            super.setCursor(this.isCollapsed ? Cursor.getPredefinedCursor(0) : Cursor.getPredefinedCursor(9));
        }

        @Override
        protected void prepareForDragging() {
            if (!this.isCollapsed) {
                super.prepareForDragging();
            }
        }

        @Override
        protected void dragDividerTo(int location) {
            if (!this.isCollapsed) {
                super.dragDividerTo(location);
            }
        }

        @Override
        protected void finishDraggingTo(int location) {
            if (!this.isCollapsed) {
                super.finishDraggingTo(location);
            }
        }

        @Override
        public void paint(Graphics g) {
            Color c;
            Color b;
            int w = this.getWidth();
            int h = this.getHeight();
            int x = w / 2;
            Color color = b = this.isMouseOver() ? UIManager.getColor("List.selectionBackground") : this.getBackground();
            if (b == null) {
                b = this.getBackground();
            }
            g.setColor(b);
            g.fillRect(0, 0, w, h);
            Color color2 = c = this.isMouseOver() ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("controlShadow");
            if (c == null) {
                c = this.getBackground().darker();
            }
            g.setColor(c);
            if (this.isCollapsed) {
                int[] xPoints = new int[]{x - 5, x + 4, x};
                int[] yPoints = new int[]{5, 5, 0};
                g.fillPolygon(xPoints, yPoints, 3);
            } else {
                int[] xPoints = new int[]{x - 4, x + 4, x};
                int[] yPoints = new int[]{1, 1, 5};
                g.fillPolygon(xPoints, yPoints, 3);
            }
        }
    }

    private static class CustomSplitterUI
    extends BasicSplitPaneUI {
        private CustomSplitterUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new CustomSplitterDivider(this);
        }

        @Override
        public CollapsibleSplitPane getSplitPane() {
            return (CollapsibleSplitPane)super.getSplitPane();
        }

        void setCollapsed(boolean collapsed) {
            ((CustomSplitterDivider)this.getDivider()).setCollapsed(collapsed);
        }

        boolean isCollapsed() {
            return ((CustomSplitterDivider)this.getDivider()).isCollapsed();
        }
    }
}

