/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.spi.editor.AbstractEditorAction;

public class FindSelectionAction
extends AbstractEditorAction {
    static final long serialVersionUID = -5601618936504699565L;
    private static final Logger LOGGER = Logger.getLogger(FindSelectionAction.class.getName());

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            Boolean revertValue;
            EditorFindSupport findSupport = EditorFindSupport.getInstance();
            Caret caret = target.getCaret();
            int dotPos = caret.getDot();
            HashMap<String, Object> props = new HashMap<String, Object>(findSupport.createDefaultFindProperties());
            String searchWord = null;
            boolean revert = false;
            Boolean originalValue = null;
            HashMap<String, Boolean> revertMap = (HashMap<String, Boolean>)props.get("revert-map");
            Boolean bl = revertValue = revertMap != null ? (Boolean)revertMap.get("find-whole-words") : null;
            if (Utilities.isSelectionShowing((Caret)caret)) {
                searchWord = target.getSelectedText();
                originalValue = (Boolean)props.put("find-whole-words", Boolean.FALSE);
                if (Boolean.FALSE.equals(revertValue)) {
                    revertMap.remove("find-whole-words");
                } else {
                    revert = !Boolean.FALSE.equals(originalValue);
                }
            } else {
                try {
                    searchWord = Utilities.getIdentifier((BaseDocument)((BaseDocument)target.getDocument()), (int)dotPos);
                    originalValue = (Boolean)props.put("find-whole-words", Boolean.TRUE);
                    if (Boolean.TRUE.equals(revertValue)) {
                        revertMap.remove("find-whole-words");
                    } else {
                        revert = !Boolean.TRUE.equals(originalValue);
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
            }
            if (searchWord != null) {
                int n = searchWord.indexOf(10);
                if (n >= 0) {
                    searchWord = searchWord.substring(0, n);
                }
                props.put("find-what", searchWord);
                if (revert) {
                    revertMap = new HashMap<String, Boolean>();
                    revertMap.put("find-whole-words", originalValue != null ? originalValue : Boolean.FALSE);
                    props.put("revert-map", revertMap);
                }
                props.put("find-block-search", Boolean.FALSE);
                props.put("find-block-search-start", null);
                props.put("find-block-search-end", null);
                EditorUI eui = Utilities.getEditorUI((JTextComponent)target);
                if (eui.getComponent().getClientProperty("AsTextField") == null) {
                    findSupport.setFocusedTextComponent(eui.getComponent());
                }
                findSupport.putFindProperties(props);
                if (findSupport.find(null, false)) {
                    findSupport.addToHistory(new EditorFindSupport.SPW((String)props.get("find-what"), (Boolean)props.get("find-whole-words"), (Boolean)props.get("find-match-case"), (Boolean)props.get("find-reg-exp")));
                }
            }
        }
    }
}

