/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import hu.kazocsaba.imageviewer.ImageViewer;
import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.ResContainer;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.CodeArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class ImagePanel
extends ContentPanel {
    private static final long serialVersionUID = 4071356367073142688L;

    ImagePanel(TabbedPane panel, JResource res) {
        super(panel, res);
        this.setLayout(new BorderLayout());
        try {
            BufferedImage img = this.loadImage(res);
            ImageViewer imageViewer = new ImageViewer(img);
            this.add(imageViewer.getComponent());
        }
        catch (Exception e) {
            RSyntaxTextArea textArea = CodeArea.getDefaultArea(panel.getMainWindow());
            textArea.setText("Image load error: \n" + Utils.getStackTrace(e));
            this.add((Component)textArea);
        }
    }

    private BufferedImage loadImage(JResource res) {
        ResourceFile resFile = res.getResFile();
        ResContainer resContainer = resFile.loadContent();
        ResContainer.DataType dataType = resContainer.getDataType();
        if (dataType == ResContainer.DataType.DECODED_DATA) {
            try {
                return ImageIO.read(new ByteArrayInputStream(resContainer.getDecodedData()));
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Failed to load image", e);
            }
        }
        if (dataType == ResContainer.DataType.RES_LINK) {
            try {
                return ResourcesLoader.decodeStream(resFile, (size, is) -> ImageIO.read(is));
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Failed to load image", e);
            }
        }
        throw new JadxRuntimeException("Unsupported resource image data type: " + resFile);
    }

    @Override
    public void loadSettings() {
    }
}

