/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.xbean.recipe.CircularDependencyException;
import org.apache.xbean.recipe.DefaultRepository;
import org.apache.xbean.recipe.ExecutionContext;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.Reference;
import org.apache.xbean.recipe.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutionContext
extends ExecutionContext {
    private Repository repository;
    private final LinkedList<Recipe> stack = new LinkedList();
    private final SortedMap<String, List<Reference>> unresolvedRefs = new TreeMap<String, List<Reference>>();

    public DefaultExecutionContext() {
        this(new DefaultRepository());
    }

    public DefaultExecutionContext(Repository repository) {
        if (repository == null) {
            throw new NullPointerException("repository is null");
        }
        this.repository = repository;
    }

    @Override
    public void push(Recipe recipe) {
        if (this.stack.contains(recipe)) {
            ArrayList<Recipe> circularity = new ArrayList<Recipe>(this.stack.subList(this.stack.indexOf(recipe), this.stack.size()));
            Iterator iterator = circularity.iterator();
            while (iterator.hasNext()) {
                Recipe item = (Recipe)iterator.next();
                if (item == recipe || item.getName() != null) continue;
                iterator.remove();
            }
            circularity.add(recipe);
            throw new CircularDependencyException(circularity);
        }
        this.stack.add(recipe);
    }

    @Override
    public Recipe pop() {
        return this.stack.removeLast();
    }

    @Override
    public LinkedList<Recipe> getStack() {
        return new LinkedList<Recipe>(this.stack);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        if (repository == null) {
            throw new NullPointerException("repository is null");
        }
        this.repository = repository;
    }

    @Override
    public boolean containsObject(String name) {
        boolean contains = this.repository.contains(name);
        return contains;
    }

    @Override
    public Object getObject(String name) {
        Object object = this.repository.get(name);
        return object;
    }

    @Override
    public void addObject(String name, Object object) {
        this.repository.add(name, object);
        List list = (List)this.unresolvedRefs.remove(name);
        if (list != null) {
            for (Reference Reference2 : list) {
                Reference2.set(object);
            }
        }
    }

    @Override
    public void addReference(Reference reference) {
        Object value = this.repository.get(reference.getName());
        if (value != null && !(value instanceof Recipe)) {
            reference.set(value);
        } else {
            ArrayList<Reference> list = (ArrayList<Reference>)this.unresolvedRefs.get(reference.getName());
            if (list == null) {
                list = new ArrayList<Reference>();
                this.unresolvedRefs.put(reference.getName(), list);
            }
            list.add(reference);
        }
    }

    public SortedMap<String, List<Reference>> getUnresolvedRefs() {
        return this.unresolvedRefs;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

